function view=initSliceSlider(view)
%
% view=makeSliceButtons(view)
%
% Installs push buttons that set curSlice.
% This is used for the inplane view only.
%
% If you change this function make parallel changes in:
%    initScanSlider
%
% djh, 1/97
% bw, 12.08.00.  For more than 12 planes, we put up a slider
% instead of the individual buttons

if ~strcmp(view.viewType,'Inplane')
   error('initSliceSlider:  Only used for INPLANE window');
end

sliderHandle = view.ui.slice.sliderHandle;

% Set the step size for clicking on the arrows and the trough
nSlices = numSlices(view);

if nSlices < 2
    nSlices=2;
    set(sliderHandle,'Enable','off');
else
    set(sliderHandle,'Enable','on');
end
    
% By setting the max to a little more than nSlices, we should
% never quite reach it by clicking the arrow or the trough
set(sliderHandle,'Min',1,'Max',nSlices);
sliderStep = [1/(nSlices - 1) , 2/(nSlices - 1)];
set(sliderHandle,'sliderStep',sliderStep);

% Update the slider callback to be an integer.
sliderCb = 'val=round(get(gcbo,''Value''));';
sliderCb = sprintf('%s \n setSlider(%s,%s.ui.slice,val,0);',...
               sliderCb,view.name,view.name);
sliderCb = sprintf('%s \n setCurSlice(%s,val);',...
               sliderCb,view.name);
sliderCb = sprintf('%s \n %s=refreshScreen(%s);',...
                sliderCb,view.name,view.name);
set(view.ui.slice.sliderHandle,'CallBack',sliderCb);


% Update the edit callback to be an integer.
editCb = 'val=round(str2num(get(gcbo,''String'')));';
editCb = sprintf('%s \n setSlider(%s,%s.ui.slice,val,0);',...
               editCb,view.name,view.name);
editCb = sprintf('%s \n %s=refreshScreen(%s);',...
                editCb,view.name,view.name);
set(view.ui.slice.labelHandle,'CallBack',editCb);

% Set to a middle plane
r = get(view.ui.slice.sliderHandle,'max');
setCurSlice(view,round(r/2));

% Add a text box above the slider so we know
% how many total planes there are
pos = get(view.ui.slice.sliderHandle,'position');

% New left position
pos(1) = pos(1) + pos(3) + 0.01;
% New width
pos(3) = pos(3)/4;

str = sprintf('%.0f',nSlices);
view.ui.slice.textHandle = ...
   uicontrol('Style','text',...
   'Units','normalized',...
   'Position',pos,...
   'String',str);

return;
