function curSlice = getCurSlice(view)
%
% curSlice = getCurSlice(view)
%
% For VOLUME, gets the curSlice from the sliceOriButtons and the
% ui.slice field.  For INPLANE/FLAT, gets curSlice from the
% sliceButtons handles.
%
% djh, 8/98
% ras, 06/05: now deals w/ hidden views: if it's hidden,
% uses the tSeriesSlice field.

if isequal(view.name,'hidden')
    % no UI or slider -- use tSeries slice
    curSlice = view.tSeriesSlice;
    return
end

switch view.viewType
case 'Inplane'
   curSlice = get(view.ui.slice.sliderHandle,'val');
case {'Volume','Gray','generalGray'}
   sliceOri=getCurSliceOri(view);
   curSlice=str2num(get(view.ui.sliceNumFields(sliceOri),'String'));
case 'Flat'
    % ras 10/04:
    % now I have another view that uses >2 slices, looking
    % across levels; distinguish b/w this and the old kind
    % of flat:
    if isfield(view,'numLevels') % test for levels view
        curSlice = getFlatLevelSlices(view);
        curSlice = curSlice(1);
    else
       curSlice = findSelectedButton(view.ui.sliceButtons);
   end   
end

return;

