function view = setCurScan(view,scanNum)
%
% view = setCurScan(view,scanNum)
%
% AUTHOR: Wandell
%    Sets UI parameter of slider to scanNum
%   If the view is hidden, the UI field is absent and nothing is done.  I
%   wonder if we should return an error (or hidden) flag?
%
% ras, 05/05: added a 'curScan' field -- it'd be better to go
% back and add this at view creation, but this should produce a
% workable alternative for hidden views.

% Set the slider interface position to the scanNum
% Used to be buttons
%
if checkfields(view,'ui','scan'), 
    setSlider(view,view.ui.scan,scanNum,0); 
end

% what the hell, let's go ahead and add a 'curScan' field
% to the view:
view.curScan = scanNum;

return;

