function segmentInfo(view);
%
% AUTHOR:  Wandell
% DATE:    01.09.01
% PURPOSE:
%   Read the file paths for the current set of segmentation files.
% Then display this information to the user
%
% 7/16/02 djh, replaced mrSESSION.vAnatomyPath with global vANATOMYPATH

% Path to the anatomy data
global vANATOMYPATH

switch view.viewType
case 'Gray'
    msg = sprintf('Anatomy\n  %s\nGray:\n  left:   %s\n  right: %s\n',...
        vANATOMYPATH,view.leftPath,view.rightPath);
case 'Flat'
    msg = sprintf('Anatomy\n  %s\nFlat:\n  left:   %s\n  right: %s\n',...
        vANATOMYPATH,view.leftPath,view.rightPath);
otherwise
    msg = sprintf('Anatomy\n  %s\n',...
        vANATOMYPATH);
end

% Popup the box with the information
msgbox(msg,'Segmentation Information')

return;
