function installSegmentation(query)
%
% function installSegmentation(query)
%
% Rebuild coords after a new segmentation.
%
% Note: could automatically rebuild Gray/corAnals by xforming from inplane, but we
% would have to do this for each dataType.
%
% 12/8/00 Wandell and Huk
% djh, 2/14/2001
%    Uses hiddenGray and hiddenFlat structures rather than opening windows.
%    Uses fullfile rather than cd'ing into the directory

if ~exist('query','var')
    query = 1;
end

if query
    resp = questdlg('Delete Gray and all Flat data files and close all Gray and Flat windows?');
else
    resp = 'Yes';
end

% delete coords and rebuild
if strcmp(resp,'Yes')
    closeAllGrayWindows;
    closeAllFlatWindows;
    % Deletes coords, corAnal, and other parameter map files
    cleanGray;    
    cleanAllFlats;
    % Load gray file, compute & save coords
    hiddenGray = initHiddenGray;
    disp('Rebuilt Gray coords. Deleted old corAnal and parameter map files.');
else
    disp('Coords, corAnal, and parameter map files not deleted.');
    return;
end

return;
