function [roiInd, coords] = roiIndices(view, coords);
% [roiInd, dataCoords] = roiIndices(view, roiCoords);
%
% figure out the indices in the map
% which correspond to the current ROI.
%
% Also returns the coords in terms of the view's
% data size, rather than the view size.
%
% Note that this doesn't remove redundant coordinates (which
% result because many anaomtical coordinate may specify the same
% functional coordinate) -- that's done in roiSubCoords.
%
% ras 10/04
if ieNotDefined('coords')
    coords = view.ROIs(view.selectedROI).coords;
end

% 10/2005 SOD: if coords is a cell structure, then
% we need to convert it to a matrix. This probably should not be done
% here but it works.
% (yeah, this indicates you're probably using getTseriesOneROI, which
% I'd hope could be replaced by voxelTSeries, which doesn't return cells 
% -- I really hope the whole cell-of-coords thing goes away. The proper
% thing to do, which had been designed from the start, was to treat 
% several ROIs as a cell-of-structs anyway. -ras, 11/2005.)
if iscell(coords),
  if length(coords) == 1,
    % straightforward conversion
    coords = coords{1};
  else,
    % pick view.selectedROI
    coords = coords{view.selectedROI};
  end;
end;


switch view.viewType
    case 'Inplane'
        rsFactor = upSampleFactor(view, getCurScan(view));
        coords(1,:) = round(coords(1,:) ./ rsFactor(1));
        coords(2,:) = round(coords(2,:) ./ rsFactor(2));
        roiInd = sub2ind(dataSize(view,1), coords(1,:),...
                    coords(2,:), coords(3,:));
                
    case 'Gray'
        [subCoords roiInd] = intersectCols(view.coords, coords);
        
    case 'Flat'
        roiInd = sub2ind(size(view.indices),coords(1,:),...
                    coords(2,:),coords(3,:));
end

return
