function [view, roi] = restrictRoiToGray(view,roi);
%
% [view, roi] = restrictRoiToGray(view,roi):
%
% Restrict an roi to only gray matter voxels, independent
% of the current view type. Creates a new Roi named
% '[ROI name] (Gray)', and appends it to the view.
%
% ROI can be specified as an ROI name, index into the 
% view's ROI struct, 3 x N set of coordinates, or roi
% struct.
%
% For speed, converts non-gray Rois into a hidden gray view
% and back; because of issues related to subsampling, it 
% may be more accurate to xform over all gray coords to the 
% current view (maybe reduce partial voluming effects?), but 
% this would take a while.
% 
%
% ras, 04/05
if nargin < 2
    help(mfilename)
    return
end

% check that there's a segmentation/gray view installed
% for this session
mrGlobals;
if ~exist('sessDir','var') | isempty(sessDir)
    sessDir = pwd;
else
    % have to use a different name, b/c
    % 'homeDir is a function'. Screw this...
    % let's kill that old function.
    % In fact, why isn't this just a field of the
    % view???!
    sessDir = HOMEDIR;
end

checkFile = fullfile(sessDir,'Gray','coords.mat')
if ~exist(checkFile,'file')
    myErrorDlg('You don''t seem to have a Gray/coords.mat file.')
end

% parse how roi was specified
% (this is from the TCUI toolbox, 
% maybe I'll move it to a more general place)
roi = tc_roiStruct(view,roi);

viewType = viewGet(view,'viewType');

% intersect w/ gray coords, appropriate to view
switch viewType
case 'Gray',
    % can do this easily, by intersecting w/ 
    % existing coords
    roi.coords = intersectCols(roi.coords,view.coords);
    
case 'Volume',
    % this is also easy: the coords aren't
    % in the view, but they're in the right 
    % coordinate space -- just load the file
    load(checkFile,'coords')
    roi.coords = intersectCols(roi.coords,coords);
    
    % append to view
    rois = viewGet(view,'ROIs');
    if isempty(rois)
        rois = roi;
    else
        rois(end+1) = sortFields(roi);
    end
    
    % and we're done!
    return
    
case 'Inplane',
    % need to initialize a hidden
	% gray and xform back and forth: 
	gray = initHiddenGray;
    grayRoi = ip2volROI(roi,view,gray);

    % restrict by gray coords
	grayRoi.coords = intersectCols(grayRoi.coords,gray.coords);

    if isempty(grayRoi.coords)
        msg = sprintf('%s was found to have no gray coords.',roi.name);
        msg = sprintf('%s Check the ROI definition, and maybe the alignment or segmentation.',msg);
        myWarnDlg(msg);
        return
    end
    
    % xform back (update roi)
    roi = vol2ipROI(grayRoi,gray,view);  
    
case 'Flat',
    % By definition, these are restricted to gray:
    warnDlg('You''re in a FLAT view -- all Rois are already restricted to gray!')
    return
    
end

% set ROI name
roi.name = [roi.name ' (Gray)'];

% append to view
rois = viewGet(view,'ROIs');
if isempty(rois)
    rois = roi;
    roiNum = 1;
else
    if isfield(rois(1), 'save')
        rois = rmfield(rois, 'save');
    end
    rois(end+1) = sortFields(roi);
    roiNum = length(rois);
end
view = viewSet(view,'ROIs',rois);
view = viewSet(view,'selectedROI',roiNum);

% update roi popup, if appropriate:


% and we're done!

return
