function [newCoords, rows, cols] = montage2Coords(view,montageCoords);
%
% newCoords = montage2Coords(view,montageCoords);
%
% For montage views (inplane montage & flat across-levels),
% convert a set of coordinates given relative to the view's
% current montage image into the proper coordinates for the
% view.
%
% montageCoords should be a matrix with two rows, 
% specifying the (y,x) (i.e., row/column) location
% of a set of voxels. If there are more than two 
% rows, subsequent rows are ignored. newCoords is 
% a 3xN matrix, specifying the same voxels in the 
% conventions used by ROIs for that view.
%
% 09/04 ras.
if nargin < 2
    help montage2Coords
    return
end

if size(montageCoords,1) < 2
    error('montageCoords needs >= 2 rows.');
end

%%%%% get info about the montage size, slice size
ui = viewGet(view,'ui');
[selectedSlices nrows ncols] = montageDims(view);


% get zoom size (size of each img in montage)
zoom = ui.zoom;
dims = [zoom(4)-zoom(3)+1 zoom(2)-zoom(1)+1];
dims = round(dims);
ycorner = ui.zoom(3) - 1; % location of upper-right corner w/ zoom
xcorner = ui.zoom(1) - 1;

% get slice #
rows = ceil(montageCoords(1,:)./dims(1));
cols = ceil(montageCoords(2,:)./dims(2));
sliceInds = (rows-1)*ncols + cols;
slices = selectedSlices(sliceInds);

% get x/y pos within slice
y = mod(montageCoords(1,:)-1,dims(1)) + 1;
x = mod(montageCoords(2,:)-1,dims(2)) + 1;
y = y + ycorner;
x = x + xcorner;

% build newCoords from slice, position info
newCoords = zeros(3,size(montageCoords,2));
newCoords(1,:) = y;
newCoords(2,:) = x;
newCoords(3,:) = slices;

newCoords = round(newCoords);

return
