function [view,OK] = combineROIs(view)
% function [view,OK] = combineROIs(view)
% 
% opens a dialog box that allows the user to combine 2 ROIs 
% into a third new ROI using logical operators:
%
% Union:  set union
% Intersection : set intersection
% XOR : exclusive or
% A not B : set difference (all elements in A that are not also
%           in B)
% 
% rmk 10/30/98
% ras 02/08/04 -- added white as a color option (otherwise, why allow white
% ROIs?)

actionList = {'Union','Intersection','XOR','A not B'};

actionChar = char(actionList)';
actionChar = actionChar(1,:);

actionNum=1; % default to union

ROI=view.ROIs(view.selectedROI);

colorList = {'yellow','magenta','cyan','white','red','green','blue'};

colorChar = char(colorList)';
colorChar = colorChar(1,:);

colorNum = findstr(ROI.color,colorChar);

c=0;

c=c+1;
uiStruct(c).string = 'ROI 1:';
uiStruct(c).fieldName = 'name1';
uiStruct(c).style = 'edit';

c=c+1;
uiStruct(c).string = 'ROI 2:';
uiStruct(c).fieldName = 'name2';
uiStruct(c).style = 'edit';

c=c+1;
uiStruct(c).string = 'Combined ROI:';
uiStruct(c).fieldName = 'name3';
uiStruct(c).style = 'edit';

c=c+1;
uiStruct(c).string = 'Combined Color:';
uiStruct(c).fieldName = 'color';
uiStruct(c).list = colorList;
uiStruct(c).choice = colorNum;
uiStruct(c).style = 'popupmenu';

c=c+1;
uiStruct(c).string = 'Action';
uiStruct(c).fieldName = 'action';
uiStruct(c).list = actionList;
uiStruct(c).choice = actionNum;
uiStruct(c).style = 'popupmenu';

height = 1;
vSkip = 0.3;
pos = [35,10,30,length(uiStruct)*(height+vSkip)+3];
x = 1;
y = length(uiStruct)*(height+vSkip)+1;
editWidth = 10;
stringWidth = pos(3)-editWidth-2;

n=length(uiStruct);

for uiNum = 1:n-3
  uiStruct(uiNum).stringPos = [x,y,stringWidth,height];
  uiStruct(uiNum).editPos = [x+stringWidth-1,y,editWidth,height];
  uiStruct(uiNum).value = ...
      getfield(ROI,'name');
  y = y-(height+vSkip);
end

uiStruct(n-2).stringPos = [x,y,stringWidth,height];
uiStruct(n-2).editPos = [x+stringWidth-1,y,editWidth,height];
uiStruct(n-2).value = 'combROI';
y = y-(height+vSkip);

uiStruct(n-1).stringPos = [x,y,stringWidth,height];
uiStruct(n-1).editPos = [x+stringWidth-1,y,editWidth,height];
uiStruct(n-1).value = 'blue';
y = y-(height+vSkip);

uiStruct(n).stringPos = [x,y,stringWidth,height];
uiStruct(n).editPos = [x+stringWidth-1,y,editWidth,height];
uiStruct(n).value = 'Union';
y = y-(height+vSkip);

outStruct = generaldlg(uiStruct,pos);

% If user selects 'OK', change the parameters.  Otherwise the
% user isn't happy with these settings so bail out.

if ~isempty(outStruct)
  % if modification occurs then perform operation and create
  % combined ROI:
  
  % first find input ROIs:
  
  r1=findROI(view,outStruct.name1);
  
  if r1==0
    if check4File([view.subdir,'/ROIs/',outStruct.name1])
      view=loadROI(view,outStruct.name1);
      r1=findROI(view,outStruct.name1);
    end
  end
  
  r2=findROI(view,outStruct.name2);
  
  if r2==0
   if check4File([view.subdir,'/ROIs/',outStruct.name2])
     view=loadROI(view,outStruct.name2);
     r2=findROI(view,outStruct.name2);
   end
  end
  
  if (r1==0 | r2 == 0)
    errordlg('One of the input ROIs does not exist!','Error');
    return;
  end
  
  if (r1==r2)
    errordlg('Both input ROIs are the same!','Error');
    return;
  end
  
  
  % now perform operation:
  coords=combineCoords(view.ROIs(r1).coords,view.ROIs(r2).coords,outStruct.action);
  
  % now add new ROI:
 
  ROI.color=outStruct.color(1);
  ROI.coords=coords;
  ROI.name=outStruct.name3;
  ROI.viewType=view.viewType;
 
  ROI=sortFields(ROI);  
  
  view=addROI(view,ROI);
  
  OK = 1;
else 
  OK = 0;
end





