function view = addROIpoly(view,sgn)
%
% view = addROIpoly(view,,[sgn])
%
% If sgn~=0, adds user-specified polygon to selected ROI in
% current slice. If sgn==0, removes the polygon from the ROI.
%
% If you change this function make parallel changes in:
%   all addROI*.m functions
%
% gmb, 4/23/98 adapted addROIpoly from mrSelPolyRet, added sgn
% djh, 7/98 updated to use ROIcoords instead of selpts
% 2002.10.23 RFD: Replaced 'markPoly' with matlab's 'roipoly'. We now no
% longer depend on the ancient mex function 'mrManifoldDistance', which 
% seems to be broken in Matlab 6.5 anyway.

% error if no current ROI
if view.selectedROI == 0
  myErrorDlg('No current ROI');
  return
end

if ~exist('sgn','var')
  sgn = 1;
end

% Get current ROI coords
curCoords = getCurROIcoords(view);

% Save prevSelpts for undo
view.prevCoords = curCoords;

% Get curSlice
curSlice = getCurSlice(view);

% 2002.10.23 RFD We now use matlab's 'roipoly' function to replace
% markPoly.
polyIm = roipoly;

% % markPoly returns an image with 1's marking the polygon
% dims=size(view.ui.image);
% polyIm = markPoly(dims);

% Compute image coordinates
polyImIndices = find(polyIm);
polyImCoords = indices2Coords(polyImIndices,size(polyIm));

% Add curSlice as 3rd row to get volume coordinates
polyCoords = [polyImCoords; curSlice*ones(1,size(polyImCoords,2))];

% Do an (inverse) rotation if necessary
if (strcmp(view.viewType,'Flat'))
    polyCoords=(rotateCoords(view,polyCoords,1));
end


% Convert coords to canonical frame of reference
polyCoords = curOri2CanOri(view,polyCoords);

% Merge/remove coordinates
if sgn
  coords = mergeCoords(curCoords,polyCoords);
else
  coords = removeCoords(polyCoords,curCoords);
end
view.ROIs(view.selectedROI).coords = coords;
