function [view,pos] = addROI(view,ROI,select)
%
% [view,pos] = addROI(view,ROI,[select])
%
% Adds an ROI to the ROIs list of a view.  If select is non-zero
% (the default), selects it.  
% If requested, the position of the ROI in the list is passed
% back.
% 
% If you change this function make parallel changes in:
%   all addROI*.m functions
%
% djh, 8/98
%
% AW/BW:  11.14.00 Modified for R12
%         When the view.ROIs is initialized to [], we cannot
%         assign it a structure in Matlab R12.  So, when it is null,
%         we remove the ROIs field before assigning.

if ieNotDefined('select'), select=1; end

pos = 1;
if isfield(view,'ROIs')
    if isempty(view.ROIs)
        % disp('Clearing ROIs field');
        view = rmfield(view,'ROIs');
    else
        pos = length(view.ROIs)+1;
    end
end

for f = fieldnames(ROI)'
    view.ROIs(pos).(f{1}) = ROI.(f{1});
end

if select
  view = selectROI(view,pos);
  
	% for volume views, find the ROI as it's loaded
	viewType = viewGet(view,'viewType');
	if (isequal(viewType,'Volume') | isequal(viewType,'Gray')) 
        if ~isequal(view.name,'hidden') & ~isempty(ROI.coords)
            view = selectCurROISlice(view);
            view = refreshScreen(view);
        end
    end
end

% Set the ROI popup menu
setROIPopup(view);

return;
