function plotSingleCycleErr(view,scan)
%
% plotSingleCycle(view) 
%
%  Author:  BW 
%  Purpose: 
%    Plot the time series data of a single cycle.   All cycles in a scan
%    are collapsed into one cycle. This is meant to be somthing like the
%    average over repetitions in the scan. The mean is plotted with
%    standard error bars. Modified from mrLoadRet-2.5 version. 
% 2005.04.04 AB added sections to transfer ROI to INPLANE from gray of flat
% so that plots could be made from the gray and flat views as well as from
% inplane.

mrGlobals;
global FLAT
global selectedFlat
global VOLUME
global selectedVOLUME
global INPLANE
global selectedINPLANE

% These should be updated to viewGet calls.
if ieNotDefined('scan'), scan = getCurScan(view); end

nCycles = numCycles(view,scan);
frameRate = getFrameRate(view,scan);
nFrames = numFrames(view,scan);

%%Specifics for Flat, Gray, or Inplane views - xform ROI to INPLANE view
switch view.viewType
case {'Volume' 'Gray'}   %%%For ROIs in Gray view - xform to inplane
    
    selectedVOLUME = viewSelected('volume'); 
    
    %initiate and / or select INPLANE window
    if isempty(INPLANE), 
        INPLANE{1} = initHiddenInplane;
        INPLANE{1} = viewSet(INPLANE{1},'name','hidden');
        selectedINPLANE = 1;
    else
        selectedINPLANE = viewSelected('inplane'); 
    end
    
    % Set the Inplane scan number and datatype to match the Volume view. 
    curDataType = viewGet(VOLUME{selectedVOLUME},'datatypenumber');
    INPLANE{selectedINPLANE} = viewSet(INPLANE{selectedINPLANE},'datatypenumber',curDataType);
    INPLANE{selectedINPLANE} = viewSet(INPLANE{selectedINPLANE},'currentscan',scanNum);
    
    %Transfer current VOLUME ROI to INPLANE
    INPLANE{selectedINPLANE} = vol2ipCurROI(view,INPLANE{selectedINPLANE});
    
    
case {'Flat'} %%%For ROIs in Flat view - xform to inplane

    selectedFLAT = viewSelected('flat'); 
    
    %initiate and / or select VOLUME and INPLANE windows
    if isempty(VOLUME), 
        VOLUME{1} = initHiddenGray;
        VOLUME{1} = viewSet(VOLUME{1},'name','hidden');
        selectedVOlUME = 1;
    else
        selectedVOLUME = viewSelected('volume'); 
    end
    
    if isempty(INPLANE), 
        INPLANE{1} = initHiddenInplane;
        INPLANE{1} = viewSet(INPLANE{1},'name','hidden');
        selectedINPLANE = 1;
    else
        selectedINPLANE = viewSelected('inplane'); 
    end
    
    % Set the Inplane scan number and datatype to match the Flat view. 
    %         curScan =     viewGet(FLAT{selectedFLAT},'currentscan');
    curDataType = viewGet(FLAT{selectedFLAT},'datatypenumber');
    INPLANE{selectedINPLANE} = viewSet(INPLANE{selectedINPLANE},'datatypenumber',curDataType);
    INPLANE{selectedINPLANE} = viewSet(INPLANE{selectedINPLANE},'currentscan',scan);
    
    %Transfer current FLAT ROI to INPLANE
    INPLANE{selectedINPLANE} = flat2ipCurROI(view,INPLANE{selectedINPLANE},VOLUME{selectedVOLUME});
    
case {'Inplane'}   %%%For ROIs in INPLANE view - select inplane
    selectedINPLANE = viewSelected('inplane'); 
end

% Compute the mean tSeries
ROIcoords = getCurROIcoords(INPLANE{selectedINPLANE});
tSeries = meanTSeries(INPLANE{selectedINPLANE},scan,ROIcoords);
framesPerCycle = nFrames/nCycles;

%Computer the average singlge cycle
multiCycle  = reshape(tSeries,nFrames/nCycles,nCycles);
singleCycle = mean(multiCycle')';
singleCycleStdErr = (std(multiCycle')/sqrt(nCycles))';
singleCycle(end+1)=singleCycle(1);
singleCycleStdErr(end+1)=singleCycleStdErr(1);
framesPerCycle=framesPerCycle+1;

% plot it

% selectGraphWin
newGraphWin

fontSize = 14; 
t = linspace(0,(framesPerCycle-1)*frameRate,framesPerCycle)';

ROIname = view.ROIs(view.selectedROI).name;
headerStr = ['Mean Cycle, ROI ',ROIname,', scan ',num2str(scan)];

set(gcf,'Name',headerStr);
hh = errorbar(t,singleCycle,singleCycleStdErr,'k');

set(hh,'LineWidth',4);
hold on
h2=plot(t(end),singleCycle(end),'xk');
hold off;
set(h2,'Color',[0.5 0.5 0.5]);
set(h2,'LineWidth',8);

nTicks = size(tSeries,1);
xtick = [0:frameRate:framesPerCycle*frameRate];

set(gca,'xtick',xtick)
set(gca,'FontSize',fontSize)
xlabel('Time (sec)','FontSize',fontSize) 
ylabel('Percent modulation','FontSize',fontSize) 
set(gca,'XLim',[0,framesPerCycle*frameRate]);
grid on

%Save the data in gca('UserData')
data.x = t;
data.y = singleCycle;
data.e = singleCycleStdErr;
set(gca,'UserData',data);


return;
