function view=plotMenu(view)
% 
% view=plotMenu(view)
% 
% djh, 4/98
% $Date: 2006/02/28 00:52:27 $
% $Author: dumoulin $
% ras, 06/18/04: added some options to superimpose different
% things (maps, raw tSeries values, etc...) in 'superimpose' submenu
global HOMEDIR

plotmenuHandle = uimenu('Label','Plots','separator','on');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Current Scan submenu

curScanMenu = uimenu(plotmenuHandle,'Label','Current Scan','Separator','off');

tSeriesMenu = uimenu(curScanMenu,'Label','TSeries Analyses','Separator','off');

% plotMeanTSeries callback:
%   selectGraphWin;
%   plotMeanTSeries(view,getCurScan(view));
callBackstr=['plotMeanTSeries(',view.name,',getCurScan(',view.name,'));getPlottedData;'];
uimenu(tSeriesMenu,'Label','Mean TSeries','Separator','off',...
    'CallBack',callBackstr);

% plotMultipleTSeries callback:
%   plotMultipleTSeries(view,getCurScan(view));
callBackstr=['plotMultipleTSeries(',view.name,',getCurScan(',view.name,'));getPlottedData;'];
uimenu(tSeriesMenu,'Label','Mean TSeries of Multiple ROIs','Separator','on',...
    'CallBack',callBackstr);

% plotSingleCycle callback:
%   plotSingleCycleErr(view);
callBackstr=['plotSingleCycleErr(',view.name,');getPlottedData;'];
uimenu(tSeriesMenu,'Label','Single Cycle','Separator','on',...
    'CallBack',callBackstr);

% plotSingleCycle per condition callback:
callBackstr=[view.name '=plotMeanChopTseries(' view.name ');getPlottedData;'];
uimenu(tSeriesMenu,'Label','Single Cycle (per condition, from file)','Separator','on',...
    'CallBack',callBackstr);

% plotFFTSeries callback:
%   plotFFTSeries(view,getCurScan(view));
callBackstr=['plotFFTSeries(',view.name,',getCurScan(',view.name,'));getPlottedData;'];
uimenu(tSeriesMenu,'Label','FFT of Mean tSeries','Separator','on',...
    'CallBack',callBackstr);

% plotMultipleFFTSeries callback:
%   plotMultipleFFTSeries(view,getCurScan(view));
callBackstr=['plotMultipleFFTSeries(',view.name,',getCurScan(',view.name,'));getPlottedData;'];
uimenu(tSeriesMenu,'Label','FFT of Multiple ROIs','Separator','on',...
    'CallBack',callBackstr);

% plotMeanFFTSeries callback:
%   plotMeanFFTSeries(view,getCurScan(view));
callBackstr=['plotMeanFFTSeries(',view.name,',getCurScan(',view.name,'));getPlottedData;'];
uimenu(tSeriesMenu,'Label','Mean FFT','Separator','on',...
    'CallBack',callBackstr);

%------------------------------------------
statSummaryMenu = uimenu(curScanMenu,'Label','Summary Stats','Separator','on');

%   mrRoistats(view);
callBackstr=['mrROIstats(',view.name,');'];
uimenu(statSummaryMenu,'Label','Brief Summary','Separator','off',...
    'CallBack',callBackstr);

%   mrspMeanPhase(view);
callBackstr=['mrspMeanPhase(',view.name,');getPlottedData;'];
uimenu(statSummaryMenu,'Label','Mean Phase vs. Coherence','Separator','off',...
    'CallBack',callBackstr);

%   plotMultipleAmps_SingleCondition(['plotMultipleAmps(',view.name,');']);
callBackstr=['plotMultipleAmps_SingleCondition(',view.name,');getPlottedData;'];
uimenu(statSummaryMenu,'Label','Mean amplitudes in multiple ROIs','Separator','on',...
    'CallBack',callBackstr);

% plotCorVsPhase (cartesian) callback:
%   plotCorVsPhase(view,'cartesian');
callBackstr=['plotCorVsPhase(',view.name,',''cartesian'');getPlottedData;'];
uimenu(statSummaryMenu,'Label','Co vs. Phase (cartesian)','Separator','on',...
    'CallBack',callBackstr);

% plotCorVsPhase (polar) callback:
%   plotCorVsPhase(view,'polar');
callBackstr=['plotCorVsPhase(',view.name,',''polar'');getPlottedData;'];
uimenu(statSummaryMenu,'Label','Co vs. Phase (polar)','Separator','on',...
    'CallBack',callBackstr);

% plotCycleAmps (bar) callback:
%   plotCRF(view);
callBackstr=['plotCycleAmps(',view.name,');getPlottedData;'];
uimenu(statSummaryMenu,'Label','Individual cycle amps','Separator','on',...
    'CallBack',callBackstr);





%-----------------------------
if strcmp(view.viewType,'Flat')
    
    lineMenu = uimenu(curScanMenu,'Label','Line ROI Plots','Separator','on');

    % plotCoVsPosition callback
    callBackstr=['plotParamVsPosition(',view.name,',','''Co'');getPlottedData;'];
    uimenu(lineMenu,'Label','Co vs. Position','Separator','on',...
        'CallBack',callBackstr);
    
    % plotAmplitudeVsPosition callback
    %   plotAmplitudeVsPosition(view);
    % callBackstr=['plotAmplitudeVsPosition(',view.name,',1);'];
    callBackstr=['plotParamVsPosition(',view.name,',','''Amplitude'');getPlottedData;'];
    uimenu(lineMenu,'Label','Amplitude vs. Position','Separator','on',...
        'CallBack',callBackstr);
        
    % plotPhaseVsPosition callback
    %   plotPhaseVsPosition(view); 
    % plotParamVsPosition( view, plotParam, scanList ); 
    % by leaving out 'scanList' we get a plot for the current Scan
    callBackstr=['plotParamVsPosition(',view.name,',','''Phase'');getPlottedData;'];
    uimenu(lineMenu,'Label','Phase vs. Position','Separator','on',...
        'CallBack',callBackstr);  
    
    % plotParamVsDistance callback
    %    ROIdata = plotParamsVsDistance(view, [plotParam], [scanNum], ...
    %                               [ROIdata], [binSize], [plotFlag]);
    % callBackstr=['ROIdata = plotParamVsDistance(',view.name,',1);'];
    callBackstr=['plotParamVsDistance(',view.name,');getPlottedData;'];
    uimenu(lineMenu,'Label','Parameter vs. Distance','Separator','on',...
        'CallBack',callBackstr);
    
    % plotProjAmpVsPosition callback
    % callBackstr=['plotProjAmpVsPosition(',view.name,',1);'];
    callBackstr=['plotParamVsPosition(',view.name,',','''Phase'');getPlottedData;'];
    uimenu(lineMenu,'Label','NYI: ProjAmp vs. Pos','Separator','on',...
        'CallBack',callBackstr);
    %-----------------
    
    % publishFigure callback
    %   publishFigure(view);
    callBackstr=[view.name,' = publishFigure(',view.name,');'];
    uimenu(curScanMenu,'Label','Publish Figure','Separator','on',...
        'CallBack',callBackstr);
    callBackstr=[view.name,' = publishFigure(',view.name,', ''paramPrompt'');'];
    uimenu(curScanMenu,'Label','Publish Figure (set params)','Separator','off',...
        'CallBack',callBackstr);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Across Scans submenu

acrossScanMenu = uimenu(plotmenuHandle,'Label','Across Scans','Separator','on');

% plotVectorMean callback:
%   plotVectorMean(view);
callBackstr=['plotVectorMean(',view.name,');getPlottedData;'];
uimenu(acrossScanMenu,'Label','Vector Mean (polar)','Separator','off',...
    'CallBack',callBackstr);

% plotCorrelations callback:
%   plotCorrelations(view);
callBackstr=['plotCorrelations(',view.name,');getPlottedData;'];
uimenu(acrossScanMenu,'Label','Correlations (bar)','Separator','on',...
    'CallBack',callBackstr);

% amplitude menu
ampMenu = uimenu(acrossScanMenu,'Label','Amplitudes','Separator','on');

% plotAmps callback:
%   plotAmps(view);
callBackstr=['plotAmps(',view.name,');getPlottedData;'];
uimenu(ampMenu,'Label','Current ROI (bar)','Separator','on',...
    'CallBack',callBackstr);

% plotMultipleAmps callback:
%   plotMultipleAmps(view);
callBackstr=['plotMultipleAmps(',view.name,');getPlottedData;'];
uimenu(ampMenu,'Label','Multiple ROIs (bar)','Separator','on',...
    'CallBack',callBackstr);

% plotMultipleAmps_perCondition callback:
%   plotMultipleAmps_perCondition(view);
callBackstr=['plotMultipleAmps_perCondition(',view.name,');getPlottedData;'];
uimenu(ampMenu,'Label','Multiple ROIs per condition','Separator','on',...
    'CallBack',callBackstr);

% relative amplitude menu
relAmpMenu = uimenu(acrossScanMenu,'Label','Relative Amplitudes','Separator','on');

% plotRelativeAmps callback:
%   plotAmps(view);
callBackstr=['plotRelativeAmps(',view.name,');getPlottedData;'];
uimenu(relAmpMenu,'Label','Current ROI (bar)','Separator','on',...
    'CallBack',callBackstr);

% plotMultipleRelAmps callback:
%   plotMultipleRelAmps(view);
callBackstr=['plotMultipleRelAmps(',view.name,');getPlottedData;'];
uimenu(relAmpMenu,'Label','Multiple ROIs (bar)','Separator','on',...
    'CallBack',callBackstr);

% projected amplitude menu
projAmpMenu = uimenu(acrossScanMenu,'Label','Projected Amplitudes','Separator','on');

% plotProjectedAmps callback:
%   plotProjectedAmps(view);
callBackstr=['plotProjectedAmps(',view.name,');getPlottedData;'];
uimenu(projAmpMenu,'Label','Current ROI (bar)','Separator','on',...
    'CallBack',callBackstr);

% plotMultipleProjectedAmps callback:
%   plotMultipleProjAmps(view);
callBackstr=['plotMultipleProjectedAmps_PerCondition(',view.name,');getPlottedData;'];
uimenu(projAmpMenu,'Label','Multiple ROIs (bar)','Separator','on',...
    'CallBack',callBackstr);

% relative projected amplitude menu
relProjAmpMenu = uimenu(acrossScanMenu,'Label','Relative Projected Amplitudes','Separator','on');

% plotRelativeProjectedAmps callback:
%   plotRelativeProjectedAmps(view);
callBackstr=['plotRelativeProjectedAmps(',view.name,');getPlottedData;'];
uimenu(relProjAmpMenu,'Label','Current ROI (bar)','Separator','on',...
    'CallBack',callBackstr);

% plotMultipleRelativeProjectedAmps callback:
%   plotMultipleRelProjAmps(view);
callBackstr=['plotMultipleRelProjAmps(',view.name,');getPlottedData;'];
uimenu(relProjAmpMenu,'Label','Multiple ROIs (bar)','Separator','on',...
    'CallBack',callBackstr);

% plotParamMap callback:
%   plotParamMap(view);
callBackstr=['plotParamMap(',view.name,');getPlottedData;'];
uimenu(acrossScanMenu,'Label','Parameter Map (bar)','Separator','on',...
    'CallBack',callBackstr);
  
% Laminar amplitudes
callBackstr = 'PlotMultipleLaminarProfiles;';
uimenu(acrossScanMenu, 'Label', 'Laminar amplitudes', 'Separator', 'on',...
  'CallBack', callBackstr);

% In the flat map view, we may want to create line ROIs and then
% plot a parameter as a function of the line position.  So if this is
% a Flat view, we add the plotParamVsPosition calls.
% It appears to me that the file plotParamVsPosition doesn't exist yet,
% and that it was someone's intention to write it.
if strcmp(view.viewType,'Flat')
    
    % plotPhaseVsPosition callback
    %   plotPhaseVsPosition(view); 
    % plotParamVsPosition( view, plotParam, scanList ); % option==1 is to get to choose scans
    callBackstr=['plotParamVsPosition(',view.name,',','''Phase'');getPlottedData;'];
    uimenu(acrossScanMenu,'Label','Phase vs. Position (line ROI)','Separator','on',...
        'CallBack',callBackstr);
    
    % plotCoVsPosition callback
    %   plotCoVsPosition(view); 
    % plotParamVsPosition( view, plotParam, scanList ); % option==1 is to get to choose scans
    callBackstr=['plotParamVsPosition(',view.name,',''Co'',1);getPlottedData;'] ;
    uimenu(acrossScanMenu,'Label','Co vs. Position (line ROI)','Separator','on',...
        'CallBack',callBackstr);
    
    % plotAmplitudeVsPosition callback
    %   plotAmplitudeVsPosition(view);
    % callBackstr=['plotAmplitudeVsPosition(',view.name,',1);'];
    callBackstr=['plotParamVsPosition(',view.name,',''Amplitude'',1);getPlottedData;'];
    uimenu(acrossScanMenu,'Label','Amplitude vs. Position (line ROI)','Separator','on',...
        'CallBack',callBackstr);
    
    % plotProjAmpVsPosition callback
    %   plotProjAmpVsPosition(view);
    % callBackstr=['plotProjAmpVsPosition(',view.name,',1);'];
%     callBackstr=['plotParamVsPosition(',view.name,',''ProjAmp'',1);'];
%     uimenu(acrossScanMenu,'Label','Projected Amplitude vs. Position (line ROI)','Separator','on',...
%         'CallBack',callBackstr);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

rmMenu = uimenu(plotmenuHandle,'Label','Retinotopic Model','Separator','on');

% plot both
callBackstr=['rmPlot(',view.name,',''all'');'];
uimenu(rmMenu,'Label','Receptive Field & Model Fit','Separator','off',...
    'CallBack',callBackstr);

% plot RF
callBackstr=['rmPlot(',view.name,',''rf'');'];
uimenu(rmMenu,'Label','Receptive Field','Separator','off',...
    'CallBack',callBackstr);

% plot fit
callBackstr=['rmPlot(',view.name,',''ts'');'];
uimenu(rmMenu,'Label','Model Fit','Separator','off',...
    'CallBack',callBackstr);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Check for tSeries artifacts

tseriesMenu = uimenu(plotmenuHandle,'Label','Check for tSeries artifact','Separator','on');

% Plot rmse callback:
%    plotResidualError(view,getCurScan(view))
callBackstr=['plotResidualError(',view.name,',getCurScan(',view.name,'));'];
uimenu(tseriesMenu,'Label','RMSE with first frame','Separator','off',...
    'CallBack',callBackstr);

% Plot max frame difference callback:
%    plotMaxTSErr(view)
callBackstr=['plotMaxTSErr(',view.name,',getCurScan(',view.name,'));'];
uimenu(tseriesMenu,'Label','Max frame-to-frame difference','Separator','on',...
    'CallBack',callBackstr);

% Plot the rmse as a 3D plot across all scans
callBackstr=['plotResidualErrorAcrossScans(',view.name,');'];
uimenu(tseriesMenu,'Label','Plot error across scans','Separator','on',...
    'CallBack',callBackstr);

% Plot the rmse between the first frame of each scan across all slices
callBackstr=['plotResidualErrorBetweenScans(',view.name,');'];
uimenu(tseriesMenu,'Label','Plot RMS error between scans','Separator','on',...
    'CallBack',callBackstr);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% blur tSeries

% Blur tseries plot callback
%    blurTSeriesPlot
callBackstr=['blurTSeriesPlot'];
uimenu(plotmenuHandle,'Label','Blur tseries plot','Separator','on',...
    'CallBack',callBackstr);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% get plotted data

% Get plotted data callback
callBackstr=['getPlottedData'];
uimenu(plotmenuHandle,'Label','Dump plot data into workspace','Separator','on',...
    'CallBack',callBackstr);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% plot colorbar
cbMenu = uimenu(plotmenuHandle,'Label','Color bar plots','Separator','on');

% Create a figure with the wedge map in it.  
cb = sprintf('cmapWedge(%s);', view.name);
uimenu(cbMenu, 'Label', 'Polar Angle Wedge', 'Separator', 'off',...
        'CallBack', cb);

% Create a figure with the eccentricity map in it.  
cb = sprintf('plotEccRing(%s);',view.name);
uimenu(cbMenu,'Label','Eccentricity rings','Separator','off',...
        'CallBack',cb);


% Get plotted data callback
callBackstr=['plotColorbar(',view.name,')'];
uimenu(cbMenu, 'Label', 'Plot current colorbar', 'Separator', 'off',...
        'CallBack', callBackstr);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Superimpose / Overlay stuff submenu
overlayMenu = uimenu(plotmenuHandle,'Label','Superimpose','Separator','on');

% Superimpose mean functional from first and last scans
callBackstr=['overlayMeanTSeries(',view.name,');'];
uimenu(overlayMenu,'Label','Mean tSeries from 1st and last scans','Separator','off',...
    'CallBack',callBackstr);

% Superimpose mean functional from two user-chosen scans
callBackstr=['overlayMeanTSeries(',view.name,',0,0);'];
uimenu(overlayMenu,'Label','Mean tSeries (choose scans)','Separator','off',...
    'CallBack',callBackstr);


% superimpose two maps/fields, same session
callBackstr=['overlayMapsSameSession(',view.name,');'];
uimenu(overlayMenu,'Label','Two maps/corAnal fields, same session','Separator','off',...
    'CallBack',callBackstr);

% superimpose two maps, select files
callBackstr=['overlayMapFiles(',view.name,');'];
uimenu(overlayMenu,'Label','Two maps, select files','Separator','off',...
    'CallBack',callBackstr);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Time Course UI (this requires parfiles, but I figure   %
% this is useful enough to be put in general use)        %
% (see Rory if you're unsure how to use this, or see     %
% the Readme.txt under mrLoadRet-3.0/EventRelated)       %  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% time course UI submenu:
tcMenu = uimenu(plotmenuHandle,'Label','Time Course UI','Separator','on');

% time course UI callback:
%  timeCourseUI(view);
cbstr=['timeCourseUI(' view.name ');'];
uimenu(tcMenu,'Label','Current Scan','Separator','on',...
    'CallBack',cbstr);

% time course UI callback (multiple scans):
%  tc_plotScans(view);
cbstr=['tc_plotScans(' view.name ');'];
uimenu(tcMenu,'Label','Select Scans','Separator','on',...
    'CallBack',cbstr);

% time course UI callback (scan group):
%  tc_plotScans(view,1);
cbstr=['tc_plotScans(' view.name ',1);'];
uimenu(tcMenu,'Label','Scan Group','Separator','on',...
    'CallBack',cbstr);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Show a movie or montage for inplane view       %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if strcmp(view.viewType,'Inplane')
   
   movieMenu = uimenu(plotmenuHandle,'Label','tSeries movie','Separator','on');
   
    % Movie w/ Java UI (cur slice, cur scan):
  	%   tSeriesMovie(view);
    cbstr = sprintf('%s.ui.movie = tSeriesMovie(%s);',view.name,view.name);
    uimenu(movieMenu,'Label','Movie UI (cur scan)','Separator','on',...
      	'CallBack',cbstr);

    % Movie w/ Java UI (cur slice, cur scan):
  	%   tSeriesMovie(view,1:numScans(view));
    cb = sprintf('%s.ui.movie = tSeriesMovie(%s,',view.name,view.name);
    cb = [cb sprintf('1:numScans(%s));',view.name)];
    uimenu(movieMenu,'Label','Movie UI (all scans)','Separator','off',...
      	'CallBack',cb);

    % Movie w/ Java UI (set params):
  	%   tSeriesMovie(view);
    cbstr = sprintf('%s = callTSeriesMovie(%s);',view.name,view.name);
    uimenu(movieMenu,'Label','Movie UI (set params)','Separator','off',...
      	'Accelerator','7','CallBack',cbstr);


	% Make a movie without anatomies:
  	%   view=makeTSeriesMovie(view,getCurScan(view),getCurSlice(view),0);
  	callBackstr=[view.name,'=makeTSeriesMovie(',view.name,...
            ',getCurScan(',view.name,'),getCurSlice(',view.name,'),0);'];
  	uimenu(movieMenu,'Label','Make movie without anatomies','Separator','on',...
      	'CallBack',callBackstr);
   
	% Make a movie with anatomies:
  	%   view=makeTSeriesMovie(view,getCurScan(view),getCurSlice(view),1);
  	callBackstr=[view.name,'=makeTSeriesMovie(',view.name,...
            ',getCurScan(',view.name,'),getCurSlice(',view.name,'),1);'];
  	uimenu(movieMenu,'Label','Make movie with anatomies','Separator','off',...
      	'CallBack',callBackstr);
    
	% Make a movie without anatomies (all slices):
  	%   view=makeTSeriesMovie(view,getCurScan(view),getCurSlice(view),0,0);
  	callBackstr=[view.name,'=makeTSeriesMovie(',view.name,...
            ',getCurScan(',view.name,'),0,0,0);'];
  	uimenu(movieMenu,'Label','Make move w/o anat (all slices)','Separator','off',...
      	'CallBack',callBackstr);
   
	% Make a movie with anatomies (all slices):
  	%   view=makeTSeriesMovie(view,getCurScan(view),getCurSlice(view),1,0);
  	callBackstr=[view.name,'=makeTSeriesMovie(',view.name,...
            ',getCurScan(',view.name,'),0,1,0);'];
  	uimenu(movieMenu,'Label','Make movie w/ anat (all slices)','Separator','off',...
      	'CallBack',callBackstr);
    
    % (Re-)show a movie:
  	%   showTSeriesMovie(view);
  	callBackstr=['showTSeriesMovie(',view.name,');'];
  	uimenu(movieMenu,'Label','Re-show movie','Separator','off',...
      	'CallBack',callBackstr);

   montageMenu = uimenu(plotmenuHandle,'Label','tSeries montage','Separator','off');
   
	% Show a montage of current scan:
  	%   tseriesPict(getCurScan(',view.name,'))
  	callBackstr=['tseriesPict(',view.name,',getCurScan(',view.name,'));'];
  	uimenu(montageMenu,'Label','Current scan','Separator','off',...
      	'CallBack',callBackstr);
  	callBackstr=['tseriesPict(',view.name,',getCurScan(',view.name,'),[],',HOMEDIR,');'];
  	uimenu(montageMenu,'Label','Current scan (JPEG save)','Separator','off',...
      	'CallBack',callBackstr);
      
   % Show a montage of all scans:
  	%   tseriesPict;
   callBackstr=['tseriesPict(',view.name,');'];
  	uimenu(montageMenu,'Label','All scans','Separator','on',...
      	'CallBack',callBackstr);
  	callBackstr=['tseriesPict(',view.name,',[],[],',HOMEDIR,');'];
  	uimenu(montageMenu,'Label','All scans (JPEG save)','Separator','off',...
      	'CallBack',callBackstr);
end


return
