function figureData=getPlottedData
%
%     figureData=getPlottedData
%
% Places plotted data into a mrSESSION structure, mrSESSION.figureData.
%
% figureData is a 1xn cell array with each cell containing a UserData
% structure from each axis. Thus, if the plot contains 3 separate axes,
% figureData will be a 1x3 cell array. Each substructure will contain,
% typically, y and seY as well as the title of the axis that begot it (I
% think that's British speak from Alex [BW]).  
%
% This function is called automatically after many common plotting commands
% invoked from the pull-down 'Plot' menu. Or you can call it yourself from
% the command like 
% e.g. getPlottedData
% disp(mrSESSION.figureData{1})
%
% NB: mrSESSON has to exist for this to work. 
% ARW 12/16/04


global mrSESSION
global GRAPHWIN
global figureData

if GRAPHWIN
    set(0,'CurrentFigure',GRAPHWIN);
    a=get(gcf,'Children');
    a=sort(a);
    
    if (length(a)==1)
        mrSESSION.figureData = get(gca,'UserData');
    else
        mrSESSION.figureData=cell(1,1);
        for t=1:length(a)
            
            thisData=get(a(t),'UserData');
            thisTitleHandle=get(a(t),'Title');
            thisTitle=get(thisTitleHandle,'String');
            thisData.title=thisTitle;
            
            mrSESSION.figureData{t}=thisData;
        end
    end
    
else
    myWarnDlg('Graph window needed before you can place the data into the workspace.');
end

return;