function mvNew = mv_selectSubset(mv,X,metric,newUIFlag);
%
% mvNew = mv_selectSubset([mv,X,metric,newUIFlag]);
%
% Select a subset of voxels in a MultiVoxel UI, to 
% start a new MVUI. This is intended as a callback to
% plots of classifier performance vs. number of voxels
% (see mv_sortByVoxR), but can be called from the command
% line or generalized.
%
% mv: mv struct
% X: X location on axes / # of voxels to restrict with, 
%    sorted by current metric.
% metric: metric to use -- could be 'voxR', 'omniR', or 'MI'
% newUIFlag: if 1, will open a new UI; if 0, won't [may expand this]
% 
% ras, 09/2005.
if ieNotDefined('mv'), mv = get(gcf,'UserData'); end
if ieNotDefined('X'), pt=get(gca,'CurrentPoint'); X=pt(1); end
if ieNotDefined('metric'), metric = 'voxR'; end
if ieNotDefined('newUIFlag')
    AX = axis;
    h1=line([1 1],[AX(3) AX(4)],'Color','r');
    h2=line([X X],[AX(3) AX(4)],'Color','r');
    q='Start up a new MultiVoxel UI with the Selected Subset of Voxels?';
    resp=questdlg(q,'Restrict Multivoxel','Yes','No','Cancel','Yes');
    if isequal(resp,'Cancel')
        delete([h1 h2])
        return
    elseif isequal(resp,'Yes')
        newUIFlag = 1;
    else 
        newUIFlag = 0;
    end
    % delete([h1 h2])
end

mvNew = mv;

% get the sorting data for the selected metric
field = sprintf('%sSorting',metric);
sorting = mv.(field);

% keep only voxels that fall within the selected range
keep = find(sorting.rank <= X);
mvNew.tSeries = mvNew.tSeries(:,keep);

% also set roi coords to reflect only kept voxels
mvNew.coords = mvNew.coords(:,keep);
mvNew.roi.coords = mvNew.roi.coords(:,keep);

% recompute voxData matrix
mvNew.voxData = er_voxDataMatrix(mvNew.tSeries,mvNew.trials,mvNew.params);

% recompute voxAmps matrix
mvNew.voxAmps = er_voxAmpsMatrix(mvNew.voxData,mvNew.params);

% start a new UI
if newUIFlag==1
    mvNew = mv_openFig(mvNew);
    mvNew = mv_reliability(mvNew);
end

return


