function mv = mv_selectPlotType(type);
%
% mv = mv_selectPlotType(type);
%
% Set the Multi Voxel UI to plot the selected plot
% type. 
% 
% Default types are:
% 1) Plot the whole time courses for each voxel, after
%    detrending/preprocessing.
% 2) Plot the time courses for each trial and condition,
%    averaged across voxels.
% 3) Plot the time courses for each voxel and condition,
%    averaged across trials.
% 4) Plot the mean amplitudes for each voxel and condition,
%    averaged across trials.
% 5) Plot the mean amplitudes for each trial, voxel, and condition.
% 
%
% ras, 04/05.
mv = get(gcf,'UserData');
mv.ui.plotType = type;
set(gcf,'UserData',mv);

% make only the selected option checked
if isfield(mv.ui,'plotHandles')
    set(mv.ui.plotHandles,'Checked','off')
    set(mv.ui.plotHandles(type),'Checked','on');
end

% multiVoxelUI;

return
