function mv = mv_plotsMenu(mv,hfig);
%
% mv = mv_plotsMenu(mv,hfig);
%
% Attach menus providing plotting options for
% the MultiVoxel UI.
%
% ras, 04/05
if ieNotDefined('hfig')
    hfig = gcf;
end

if ieNotDefined('mv')
    mv = get(hfig,'UserData');
end

mv.ui.plotMenu = uimenu('ForegroundColor', 'k', 'Label', 'Plot', ...
                        'Separator', 'on');

h(1) = uimenu(mv.ui.plotMenu,'Label','Whole Time Course For Each Voxel',...
        'Separator','off',...
        'Accelerator','J',...
        'CallBack','mv_plotWholeTc; mv_selectPlotType(1);');

h(2) = uimenu(mv.ui.plotMenu,'Label','Mean Amps: Voxel by Condition',...
        'Separator','off',...
        'Accelerator','M',...
        'CallBack','mv_plotAmps([],[2 3]); mv_selectPlotType(2);');

h(3) = uimenu(mv.ui.plotMenu,'Label','Mean Amps: Trial by Voxel by Condition',...
        'Separator','off',...
        'Accelerator','N',...
        'CallBack','mv_plotAmps([],[1 2 3]); mv_selectPlotType(3);');

h(4) = uimenu(mv.ui.plotMenu,'Label','Trial Time Courses, Avg Across Voxels',...
        'Separator','off',...
        'Accelerator','K',...
        'CallBack','mv_plotVoxData([],[1 2 4]); mv_selectPlotType(4);');
    
h(5) = uimenu(mv.ui.plotMenu,'Label','Voxel Time Courses, Avg Across Trials',...
        'Separator','off',...
        'Accelerator','K',...
        'CallBack','mv_plotVoxData([],[1 3 4]); mv_selectPlotType(5);');   
    
h(6) = uimenu(mv.ui.plotMenu,'Label','Histogram of Responsive Conditions',...
        'Separator','off',...
        'Accelerator','H',...
        'CallBack','mv_condHistogram; mv_selectPlotType(6);');       
    

mv.ui.plotHandles = h;


return
