function mv = mv_plotWholeTc(mv,imgFlag);
%
%  mv = mv_plotWholeTc(mv,[imgFlag]);
%
% Plot the whole time course for each
% voxel (for MultiVoxel UI).
%
% imgFlag: if 1, will use imagesc; if 0, will
% plot each trace separately using plot. [Default is 1]
%
% ras, 04/05.
if ieNotDefined('mv'),    mv = get(gcf,'UserData');     end
if ieNotDefined('imgFlag'),    imgFlag = 1;             end

% delete existing axes
other = findobj('Type','axes','Parent',gcf);
delete(other);

axes('Position',[.15 .15 .7 .7]);

if imgFlag==1
    % plot the data in units of secs V voxels
    tr = mv.params.framePeriod;
    t = tr .* (1:size(mv.tSeries,1));
    v = 1:size(mv.tSeries,2);

    imagesc(v,t,mv.tSeries);
    colormap(mv.params.cmap);
    colorbar vert
    xlabel('[Voxel]','FontSize',mv.params.fontsz,...
           'FontName',mv.params.font);
    ytxt = sprintf('Scan Time [sec]',tr);
    ylabel(ytxt,'FontSize',mv.params.fontsz,...
           'FontName',mv.params.font);

    title('BOLD signal [% modulation]','FontName',mv.params.font,...
            'FontSize',mv.params.fontsz);
else
    plot(mv.tSeries);
    xlabel('[Voxel]','FontSize',mv.params.fontsz,...
           'FontName',mv.params.font);
    ytxt = sprintf('Scan Time [sec]',tr);
    ylabel(ytxt,'FontSize',mv.params.fontsz,...
           'FontName',mv.params.font);
end

% select this as the current plot type in the UI
mv = mv_selectPlotType(1);

return
