function mv = mv_init(view,roi,scans,dt);
% mv = mv_init(view,roi,scans,dt);
%
% Initialize a time course UI struct from a mrVista view.
%
% roi: name or # of ROI in the view.ROIs substruct. 
%
% ras, broken off from tc_openFig, 04/06/05.
global dataTYPES mrSESSION;

if ieNotDefined('view'),   view = getSelectedInplane;           end
if ieNotDefined('roi'),    roi = viewGet(view,'curRoi');        end
if ieNotDefined('dt'),     dt = viewGet(view,'curDataType');    end
if ieNotDefined('scans'),  [scans dt] = er_getScanGroup(view);  end

% get prefs
if ispref('VISTA','recomputeVoxData') 
    recomputeFlag = getpref('VISTA','recomputeVoxData');
else
    recomputeFlag = 0;
end

tic

% get roi substruct 
roi = tc_roiStruct(view,roi);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% set to proper data type
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if ischar(dt)
    % convert dt name -> index #
    mrGlobals;
    dt = existDataType(dt,dataTYPES,1);
end

if ~isequal(dt,viewGet(view,'curdt'))
    curDt = viewGet(view,'curdt');
    view = selectDataType(view,dt);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% check if parfiles are assigned (if ABAB block design or cyclic, make 'em)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
status = tc_parfilesCheck(view,scans);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% load the data from scans, parfiles
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
mv = er_voxelData(view,roi,scans,recomputeFlag);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% initialize additional fields in mv struct
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
mv.plotType = 1;
mv.params.sessionCode = mrSESSION.sessionCode;
mv.params.dataType = dataTYPES(dt).name;
mv.params.scans = scans;
mv.params.roiName = roi.name;
mv.params.ampType = 'difference';
mv.roi = roi;
mv.params.parfiles = {dataTYPES(dt).scanParams(scans).parfile};
nConds = length(unique(mv.trials.cond));

if isfield(mv.params,'condColors') & ~isempty(mv.params.condColors)
    colors = mv.params.condColors;
else
    % look up in default color order function
    colors = tc_colorOrder(nConds);
end

for i = 1:nConds
    j = mod(i-1,length(colors))+1;
    mv.trials.condColors{i} = colors{j};
end

% display legend pref
mv.params.legend = 0;

% prefs for plotting graphs, images
mv.params.cmap = jet(256);
mv.params.font = 'Helvetica';
mv.params.fontsz = 12;

% default plot type: mean amps
mv.ui.plotType = 1;

% check if we're in a deconvolved data type
curdt = viewGet(view,'curDataType');
dtName = dataTYPES(curdt).name;
if isequal(dtName,'Deconvolved')
    % fix to be compatible with deconvolved format
    mv = tc_deconvolvedTcs(view,mv);
end

% if we've had to change data type to get
% the data, change back now:
if exist('curDt','var')
    view = selectDataType(view,curDt);
end

toc

return


