function mv = mv_analysisMenu(mv,hfig);
%
% mv = mv_analysisMenu(mv,hfig);
%
% Add menus with analysis options for
% the MultiVoxel UI.
%
%
% ras, 04/05
if ieNotDefined('hfig')
    hfig = gcf;
end

if ieNotDefined('mv')
    mv = get(hfig,'UserData');
end

mv.ui.analMenu = uimenu('ForegroundColor', 'k', 'Label', 'Analysis', 'Separator', 'on');

% add bootstrapping option (odd v even trials)
uimenu(mv.ui.analMenu,'Label','Reliability Analysis (odd vs even)',...
       'Separator','off',...
       'Callback','results = mv_reliability;');

% add bootstrapping option (choose subsets)
uimenu(mv.ui.analMenu,'Label','Reliability Analysis (select subsets)',...
       'Separator','off',...
       'Callback','results = mv_reliability([],''user'');');

% sort by voxR option
uimenu(mv.ui.analMenu,'Label','Sort Voxels by Voxel Reliability',...
   'Separator','on','Callback','mv_sortByVoxR;');

% sort by omniR option
uimenu(mv.ui.analMenu,'Label','Sort Voxels by Omnibus Correlation',...
   'Separator','off','Callback','mv_sortByOmniR;');

% sort by MI option
uimenu(mv.ui.analMenu,'Label','Sort Voxels by Mutual Information',...
   'Separator','off','Callback','mv_sortByMutualInf;');

% clustering analysis option
uimenu(mv.ui.analMenu,'Label','Cluster Voxels',...
   'Separator','off','Callback','mv_basicCluster;');
   
% remove outliers option
uimenu(mv.ui.analMenu,'Label','Remove Outlier Voxels',...
   'Separator','on',...
   'Callback','mv_removeOutliers;');

% pick a subset option
uimenu(mv.ui.analMenu,'Label','Pick voxels for a new UI',...
   'Separator','on','Callback','mv_pickVoxels;');

% make a time course UI option
uimenu(mv.ui.analMenu,'Label','Time Course UI for these voxels',...
   'Separator','on','Callback','mv_makeTCUI;');


% % dump data to workspace option
% uimenu(mv.ui.analMenu,'Label','Dump Data to Workspace',...
%    'Separator','on','Callback','tc_dumpDataToWorkspace;');
% 
   
set(hfig,'UserData',mv);

return
