function reconOffline(pfileDir,writeEfileFlag,bigEndian);
% reconOffline([pfileDir,writeEfileFlag,bigEndian]);
%
% (For linux and Mac OSX only):
% Use gary's recon code (in /biac1/kgs/dataTools/) to
% make Pmags and E-file headers from Pfiles without
% logging into lucas.
%
% pfileDir: where to find the Pfiles. Defaults to the
% current directory, and also checks if there's a Raw/Pfiles
% directory relative to that directory. So you can run this
% straight from the session directory.
%
% writeEfileFlag: if 0, won't re-write the E-file headers. By
% default, it does (1).
%
% bigEndian: flag on whether the Pfiles are big-endian or
% little-endian format. Short answer: if the data were collected
% (at stanford lucas center) prior to late February 2005, set
% this flag to 1; otherwise, ignore it (it defaults to 0).
%
% This uses grecons and the -O (one file) and -b (byte swap)
% flags -- otherwise the Pmags come out messy.
%
% 09/04 ras.
% 03/05 ras: updated to deal w/ little-endian files, after
% the 3T at Lucas switched to the Excite system.
if ~isunix
    fprintf('Sorry, unix systems only (linux and Mac OS X).\n');
    return
end

if ~exist('pfileDir','var') | isempty(pfileDir)
    pfileDir = pwd;
end

if ~exist('writeEfileFlag','var') | isempty(writeEfileFlag)
    writeEfileFlag = 1;
end

if ~exist('bigEndian','var') | isempty(bigEndian)
    bigEndian = 0;
end


pattern = fullfile(pfileDir,'P*.7');
w = dir(pattern);

% may not be pfiles in the current directory, but
% in Raw/Pfiles. Check this as a backup:
if isempty(w)
    pfileDir = fullfile(pfileDir,'Raw','Pfiles');
    pattern = fullfile(pfileDir,'P*.7');
    w = dir(pattern);
end

% if still no pfiles, you're outta luck
if isempty(w)
    error(sprintf('No Pfiles found in %s.',pfileDir));
end

callingDir = pwd;
cd(pfileDir);

for i = 1:length(w)
    fname = w(i).name;

    if writeEfileFlag==1
        cmd = sprintf('/biac1/kgs/dataTools/writeihdr.lnx %s',fname);
        unix(cmd)
        fprintf('Wrote E-file header for %s.\n',fname);
    end    
    
    if bigEndian
        % big endian: for scans before the upgrade in Feb 2005
        cmd = sprintf('/biac1/kgs/dataTools/grecons -O -B %s',fname);
    else
        % little endian: after the upgrade, Pfiles now don't
        % need to be byte-swapped
        cmd = sprintf('/biac1/kgs/dataTools/grecons -O %s',fname);
    end        
    unix(cmd)

    fprintf('\n\n\t*****Reconned %s*****\n\n',fname);
end

% move the B0 estimate files into their own subdirectory, 
% and rename the B0.* files to I.*, so code like loadVolume
% which looks for the pattern I* can find them. (ras, 02/06);
try
    if ~isempty(dir('B0.*'))
        mkdir B0
        nfiles = length(dir('B0.*'));
        for i = 1:nfiles
            src = sprintf('B0.%03.0f', i);
            tgt = sprintf('B0/I.%03.0f', i);
            movefile(src, tgt);
        end
    end
end

cd(callingDir);

return