function createReadmeSession(info)
% function createReadmeSession
%
% Dialog box to get basic descriptors of session.
% Writes these to Readme file.
% Called by mrCreateReadme.m
%
% djh, 9.4.01
% ras, 01/12/04: added 'RessCoil' and 'fMRICoil' to list of available
% coils.
% ras, 04/18/04: also added 'Posthead-ReceiveOnly' to coil list.
% ras, 03/30/05: uses info from existing readme if supplied.
global mrSESSION dataTYPES

if ieNotDefined('info')
    % set blank default vals, or vals from mrSESSION
    defaults = {...
            mrSESSION.sessionCode, mrSESSION.description,...
            mrSESSION.subject,'','','','',...
            num2str(mrSESSION.examNum),'',''...
        };
else
    % get defaults from existing Readme.txt file
    defaults = {...
            info.session, info.description,...
            info.subject, info.operator, ...
            info.operator, info.magnet, info.coil...
            info.examNumber, info.sliceOrientation,...
            info.protocol...
    };
end


c=0;

title = 'SESSION IDENTIFIERS';

c=c+1;
uiStruct(c).string = 'Session code:';
uiStruct(c).fieldName = 'sessionCode';
uiStruct(c).style = 'edit';
uiStruct(c).value = defaults{1};

c=c+1;
uiStruct(c).string = 'Description:';
uiStruct(c).fieldName = 'description';
uiStruct(c).style = 'edit';
uiStruct(c).value = defaults{2};
c=c+1;
uiStruct(c).string = 'Subject:';
uiStruct(c).fieldName = 'subject';
uiStruct(c).style = 'edit'; 
uiStruct(c).value = defaults{3};

c=c+1;
uiStruct(c).string = 'Operator:';
uiStruct(c).fieldName = 'operator';
uiStruct(c).style = 'edit';  
uiStruct(c).value = defaults{4};

c=c+1;
uiStruct(c).string = 'Recon/Readme by:';
uiStruct(c).fieldName = 'scribe';
uiStruct(c).style = 'edit';  
uiStruct(c).value = defaults{5};

c=c+1;
uiStruct(c).string = 'Magnet:';
uiStruct(c).fieldName = 'magnet';
uiStruct(c).style = 'popupmenu';
uiStruct(c).list = {'1.5 T', '3 T'};
uiStruct(c).choice = 2;
uiStruct(c).value = defaults{6};

c=c+1;
uiStruct(c).string = 'Coil:';
uiStruct(c).fieldName = 'coil';
uiStruct(c).style = 'popupmenu';
uiStruct(c).list = {'Posthead',  'RessCoil', 'fMRICoil', 'Posthead-ReceiveOnly','Helmet-head','Small-head', 'GE-head', 'Flex-quad'};
uiStruct(c).choice = 1;
uiStruct(c).value = defaults{7};

c=c+1;
uiStruct(c).fieldName = 'examNumber';
uiStruct(c).string = 'Exam number:';
uiStruct(c).style = 'edit';
uiStruct(c).value = defaults{8};

c=c+1;
uiStruct(c).string = 'Slice orientation:';
uiStruct(c).fieldName = 'sliceOrientation';
uiStruct(c).style = 'popupmenu';
uiStruct(c).list = {'Oblique', 'Coronal', 'Axial', 'Saggital'};
uiStruct(c).choice = 1;
uiStruct(c).value = defaults{9};

c=c+1;
uiStruct(c).string = 'Protocol name:';
uiStruct(c).fieldName = 'protocol';
uiStruct(c).style = 'edit';  
uiStruct(c).value = defaults{10};

% Prepare to make dialog box, make it
height = 1;
vSkip = 0.12;
pos = [35,10,80,length(uiStruct)*(height+vSkip)+3];
x = 1;
y = length(uiStruct)*(height+vSkip)+1;
editWidth = 40;
stringWidth = 30;
for uiNum = 1:length(uiStruct)
    uiStruct(uiNum).stringPos = [x,y,stringWidth,height];
    uiStruct(uiNum).editPos = [x+stringWidth-1,y,editWidth,height];
    y = y-(height+vSkip);
end
outStruct = generaldlg(uiStruct,pos,title);

% Write to Readme.txt
[fid, message] = fopen('Readme.txt', 'w');    if (~exist('message','var'))
        message='default message';
    end
    
if fid == -1
    warndlg(message);
    return
end

for i = 1:length(uiStruct)
    value = getfield(outStruct,uiStruct(i).fieldName);
    str = [uiStruct(i).string ' ' value];
    fprintf(fid, '%s\n', str);
end

status = fclose(fid);
if status == -1
    warndlg(messsage);
    return
end
