function DupEdit(topH)

% DupEdit(topH)
%
% Duplicate all the editable field contents in the present scan
% forward into all subsequent session fields. Input topH is the
% handle of the top-level edit figure.
%
% DBR 4/99

% Unpack the user data from the edit figure
uiData = get(topH, 'UserData');

iS = uiData.iScan; % Present scan index
nScans = length(uiData.session.functionals); % Number of scans in session
if iS == nScans, return; end % Nothing to copy
nFields = length(uiData.scanData); % Number of scan edit fields
ok = [];
for iScan=iS+1:nScans
    for iField=1:nFields
        editFlag = uiData.scanData(iField).edit;
        if editFlag
            hContent = uiData.scanData(iField).handle;
            fName = uiData.scanData(iField).field;
            origValue = eval(['uiData.original.functionals(', int2str(iScan), ').', fName]);
            if isstr(origValue)
                evalStr = ['res = ''', get(hContent, 'string'), ''';'];
            else
                evalStr = ['res = ', get(hContent, 'string'), ';'];
            end
            ok1 = 1;
            label = uiData.scanData(iField).label;
            catchStr = ['Alert(''Problems evaluating ', label, '''); ok1 = 0;'];
            eval(evalStr, catchStr);
            ok = [ok, ok1];
            if ok1
                eval(['uiData.session.functionals(', int2str(iScan), ').', ...
                        uiData.scanData(iField).field, ' = res;']);
            else
                break % stop copying if error encountered
            end
        end
    end
end

if all(ok)
    set(topH, 'UserData', uiData);
end
