function dataTYPES = CreateNewDataTypes(mrSESSION)

% function dataTYPES = CreateNewDataTypes(mrSESSION);
%
% Create top-level dataTYPES strycture.
%
% djh 9/26/2001
% ras, 03/04: added more eventAnalysisParams, since it's assumed they'll
% be created anyway down the line (e.g., if detrend option is 2, mrLoadRet
% looks for the detrendFrames in eventAnalysisParams).
% ras, 02/06: also added the parfile and scanGroup fields for event-
% related analyses, so they're there even if they're not used.

dataTYPES.name = 'Original';

for iScan = 1:length(mrSESSION.functionals)
    dataTYPES.scanParams(iScan).annotation = '';
    dataTYPES.scanParams(iScan).nFrames = mrSESSION.functionals(iScan).nFrames;
    dataTYPES.scanParams(iScan).framePeriod = mrSESSION.functionals(iScan).framePeriod;
    dataTYPES.scanParams(iScan).slices = mrSESSION.functionals(iScan).slices;
    dataTYPES.scanParams(iScan).cropSize = mrSESSION.functionals(iScan).cropSize;
    dataTYPES.scanParams(iScan).PfileName = mrSESSION.functionals(iScan).PfileName;
    dataTYPES.scanParams(iScan).parfile = '';
    dataTYPES.scanParams(iScan).scanGroup = '';
    dataTYPES.blockedAnalysisParams(iScan).blockedAnalysis = 1;
    dataTYPES.blockedAnalysisParams(iScan).detrend = 1;
    dataTYPES.blockedAnalysisParams(iScan).inhomoCorrect = 1;
    dataTYPES.blockedAnalysisParams(iScan).temporalNormalization = 1;
    dataTYPES.blockedAnalysisParams(iScan).nCycles = 8;
    dataTYPES.eventAnalysisParams(iScan) = er_defaultParams;
end

return
