function h = CreateCommentsField(pos, topH, fontSize)
%
% h = CreateCommentsField(pos, topH, fontSize);
%
% Create a generalized comments field for UIs. This was made originally for
% the 'makeReadme' interface.
%
% DBR 4/99
% DBR 6/99  Modified to allow selectable callback string
% RAS 2/03  Made the edit fields a bit longer
% RAS 6/03  made from CreateEditRow

if ~exist('fontSize', 'var'),   fontSize = 12;              end

bkColor = get(topH, 'color');
label = 'Comments:';
content = '';
width = 50;

% text label
initPos = [pos(1) pos(2)+pos(4)*0.8 pos(3)*0.2 pos(4)*0.2];
uicontrol( ...
    'Style', 'text', ...
    'Units', 'normalized', ...
    'String', label, ...
    'BackgroundColor', bkColor, ...
    'HorizontalAlignment', 'left', ...
    'FontSize', fontSize, ...
    'Position', initPos ...
);

% Edit field: make this 3 times the height of the
% text label, so users can enter in long comments
contentPos = [pos(1)+0.25*pos(3) pos(2) 0.7*pos(3) pos(4)];
h = uicontrol( ...
    'Style', 'edit', ...
    'Units','Normalized',...
    'Max',3,...
    'String', content, ...
    'BackgroundColor', [1 1 1], ...
    'HorizontalAlignment', 'left',...
    'FontSize', fontSize, ...
    'Position', contentPos ...
);

return