function writeTiffImage(view,pathStr)
%
% writeTiffImage(view,[pathStr])
%
% Writes a tiff image of the view with the proper color map.  If
% pathStr unspecified, prompts user for a filename.
%
% djh, 12/30/98
% sod, 09/2005: could not find tiffwrite, so I replaced it with
% imwrite (matlab-function).

if ~exist('pathStr','var')
  pathStr = input('Enter filename (full path): ','s');
end

try,
  im = view.ui.image;
  modeStr=['view.ui.',view.ui.displayMode,'Mode'];
  mode = eval(modeStr);
  cmap = mode.cmap;
  % tiffwrite does not exist?!
  %tiffwrite(im,cmap,pathStr);
  imwrite(im,cmap,pathStr,'TIFF');
catch
  % hack
  im=get(get(gca,'Children'),'Cdata');
  imwrite(im,pathStr,'TIFF');
end;


