function savetSeries(tSeries,view,scan,slice)
%
% function savetSeries(tSeries,view,scan,slice)
%
% This function should be called everytime you save a tSeries.
% Makes the tSeries directory and scan subdirectory if they don't already exist.
%
% tSeries: matrix of N time samples by M pixels
% view, scan, & slice: Used only to determine the full path for the tSeries file.
%
% djh, 2/17/2001
tseriesdir = tSeriesDir(view);
scandir = ['Scan',num2str(scan)];
if ~exist(fullfile(tseriesdir,scandir),'dir')
    mkdir(tseriesdir,scandir);
end
pathStr = fullfile(tseriesdir,scandir,['tSeries',num2str(slice)]);

% Rory added the int16 in his 2005/06/29 update. This shall be disabled, because in many situations int16 loses resolution 
% (e.g. get digitization error of +/-0.025% in tSeries if the baseline value is 2000). Also problematic when averaging 
% tSeries. Anyway, hard disk is cheap nowadays! - Junjie 3/2006.
%tSeries = int16(tSeries);

%disp(['Saving: ',pathStr]);
save(pathStr,'tSeries');

return