function view = saveCorAnal(view,forceSave)
%
%   view = saveCorAnal(view,[forceSave])
%
% Save the co, amp, and ph arrays in the view's
% subdirectory.
%
% If you change this function make parallel changes in:
%   saveCorAnal, saveParameterMap
%
% djh, 2/99
% djh, 2/2001, mrLoadRet 3.0
if ieNotDefined('forceSave')
    forceSave = 0;
end
pathStr=fullfile(dataDir(view),'corAnal.mat');
% Write, though check for over-writing
%
if exist(pathStr,'file') & forceSave==0
    saveFlag = questdlg([pathStr,' already exists. Overwrite?'],...
        'Save CorAnal?','Yes','No','No');
else
    saveFlag = 'Yes';
end
if strcmp(saveFlag,'Yes')
    fprintf('Saving %s...',pathStr);
    co = view.co;
    amp = view.amp;
    ph = view.ph;
    save(pathStr,'co','amp','ph');
    fprintf('done\n');
else
    fprintf('corAnal not saved...');
end
return;
