function tSeries = loadtSeries(view,scan,slice)
%
%       tSeries = loadtSeries(view,scan,slice)
%
% Loads the tSeries corresponding to the specified scan and slice,
% and returns it.
%
% DJH 1/9/98
% 
% djh, 2/20/2001, removed interpolation, dumped dat files

% Gray tSeries are stored differently, one per scan
% This is a bit ugly, but the only way to do it (for now). DJH
if strcmp(view.viewType,'Gray'),  slice=1; end
if ieNotDefined('scan'), scan = viewGet(view, 'curScan'); end
if ieNotDefined('slice'), slice = viewGet(view, 'curSlice'); end

dirPathStr = fullfile(tSeriesDir(view),['Scan',int2str(scan)]);
fileName = fullfile(dirPathStr,['tSeries',int2str(slice)]);
    
%disp(['Loading: ',fileName]);
load(fileName);
nFrames = size(tSeries,1);
if (nFrames~=numFrames(view,scan))
    disp('WARNING: loadtSeries: number of frames in tSeries file does not match numFrames(view,scan).');
end
nPixels = size(tSeries,2);

% size check:
% ras 05/13/05, made it not do this for flat tSeries, since these
% depend on the # of nodes, not the slice dims
if nPixels ~= prod(sliceDims(view,scan)) & ~isequal(view.viewType,'Flat')
    disp('Warning: loadtSeries: number of pixels in your TSeries does not match sliceDims(view,scan).');
end
tSeries=double(tSeries);

return

