function [nodes, edges, grayPath] = loadGrayNodes(hemisphere, grayPath)
%
% [nodes, edges, grayPath] = loadGrayNodes(hemisphere, [grayPath])
%
% Loads gray nodes from specified gray class file. 
% If the file is not fully specified, opens dialog box to get it from the user.
%
% hemisphere: 'right' or 'left'
% grayPath: path string to file
%    If not specified, opens dialog box to have user find the file below:
%       /usr/local/mri/anatomy/<subject>/<hemisphere>
%
% djh, 8/98
%
% 022699 - Get anatomy path from getAnatomyPath - WAP
% 061899	- Browse with uigetfile - arw
% 080299 - fixed bug with returned restofpath, 
%          change into correct directory before browsing - arw
% 080800 - allowed returning null nodes and edges if restofpath is sent in null -- djh, bw
% 120100 - fixed bug in which when restofPath was sent in it was never
%          appended to grayPath.  BW
% 120100 - AW reorganised the logic a little. Exits immediately if restOfPath
%          is null. 
% 2/5/2001, djh - cleaned this up (major rewrite)
%          wrote getPathStrDialog.m to get the code for that outta this function
%          dumped restOfPath, replaced it with full grayPath

global mrSESSION

% Open dialog box to find gray class file
if notDefined('grayPath')
    
    % default initial directory: anatomy dir / hemisphere 
    Hemi = hemisphere; Hemi(1) = upper(Hemi(1)); % e.g., left -> Left
    startDir = fullfile(getAnatomyPath(mrSESSION.subject), Hemi);
    
    ttltxt = ['Select ',hemisphere,' hemisphere gray file'];
    
    grayPath = getPathStrDialog(startDir, ttltxt, '*.?r?y');
end 

if check4File(grayPath) 
    disp(['Loading gray graph from: ',grayPath]);
    [nodes,edges]=readGrayGraph(grayPath);
    
elseif isempty(grayPath)
    fprintf('No file selected, so no coords loaded. \n');
    nodes = [];
    edges = [];
    
else
    myWarnDlg(['File ',grayPath,' does not exist. No gray nodes loaded']);
    nodes=[];
    edges=[];
end

return;

