function view=loadCorAnal(view,ask)
% view=loadCorAnal(view,ask)
%
% Loads corAnal and fills co, amp, and ph slots in the view
% structure. 
%
% If you change this function make parallel changes in:
%   loadCorAnal, loadResStdMap, loadStdMap, loadMeanMap
%
% djh, 1/9/98
% dbr, 6/23/99  Modified to use fullfile for NT/Unix platform
%               compatibility.
% djh, 2/2001, mrLoadRet 3.0
% create the full pathStr if dataType not original
% sod, 7/2005,  Added option to look for CorAnal file (ask param). 
% will be used from fileMenu but other calls will remain the same.

if nargin < 2,
  ask = [];
end;

if ~isempty(ask),
  pathStr = getPathStrDialog(dataDir(view),...
                             ['Choose CorAnal map file name'],['*.mat']);
else,
  pathStr=fullfile(dataDir(view),'corAnal.mat');
end;

if ~exist(pathStr,'file')
    warning(['No ',pathStr,' file']); 
    return;
end

fprintf('Loading from %s ... ',pathStr);
load(pathStr);
fprintf('done.\n');

checkSize(view,co);
checkSize(view,amp);
checkSize(view,ph);

view.co = co;
view.amp = amp;
view.ph = ph;

return;

