function filename = getROIfilename(view,loadFromDefaultFlag)
% function filename = getROIfilename(view,[loadFromDefaultFlag])
% gets file names of ROIs to load
%
% djh, wrote it
% rmk, 1/12/99 modified to allow multiple ROI loads
% ARW: Modified it.
% You can now have a central 'default' ROI directory and load ROIs to and
% form that rather than from the local ROI dir. This is only meaningful for
% VOLUME views at the moment (and possibly FLAT views later on...).
% To do this, set the 'loadFromDefault' flag to 1
% You will need to add a directory structure to your anatomy/subjectDir directory.
% For example
% x:\anatomy\[subjectname]\Standard\Gray\ROIs
% Then in matlab do
% setpref('VISTA','defaultROIpath','\Standard\Gray\ROIs');



if (ieNotDefined('loadFromDefaultFlag'))
    loadFromDefaultFlag=0;
else
    disp('Loading from default dir');
end


pathStr=roiDir(view,loadFromDefaultFlag);
disp(pathStr)

[nFiles,fileList] = countFiles('*.mat',pathStr);

if ~nFiles
  myErrorDlg('No ROIs found')
  filename = '';
  return
end

%truncate off '.mat'
for i=1:nFiles
  str = char(fileList(i));
  str = str(1:findstr(str,'.mat')-1);
  fileList(i) = {str};
end

[s,ok] = listdlg('PromptString','Select an ROI',...
       'SelectionMode','multiple',...
       'ListString',fileList);

if ok
  % filename = [char(fileList(s)),'.mat'];
  for i=1:length(s)
    str = [char(fileList(s(i))),'.mat'];;
    filename(i) = {str};
  end    
else
  filename = '';
end

