function [anatPath,pathExists] = getAnatomyPath(subject)
%
% [anatPath,pathExists] = getAnatomyPath(subjectName)
%
% Gives the path to a given subject's anatomies.
%
% 2.26.99 - Written by Press
% djh, 2/15/2001 - modified to use fullfile
% huk 4/8/01 - fixed unix path (removed 'anatomy')
% pb 2/5/02 - added the last line to test (the function)
% 2003.09.02 RFD: nows checks global vANATOMYPATH and allows
% subject name to be inferred from mrSESSION.
% 2003.09.04 RFD: bug fix- return the path, *not* including 
% the vAnatomy.dat filename, when using vANATOMYPATH.
% 2003.12.18  BW  Adjusted to use with mrFlatMesh, when no mrLoadRet
% exists.  Added defaultAnatomyPath internal call. Added check for
% existence of the anatomy directory and warning message if it does not
% exist.

global mrSESSION;
global vANATOMYPATH;

% When used outside of mrVista, we return a default value.
if isempty(mrSESSION)
    anatPath = defaultAnatomyPath(subject);
    pathExists = checkAnatomyPath(anatPath, nargout<2);
    return;
end

if ieNotDefined('subject')    
    if (isfield(mrSESSION, 'subject') & ~isempty(mrSESSION.subject))
        subject = mrSESSION.subject;
    else
        error('Can''t infer subject name from mrSESSION- please be more explicit.');
    end
end

if(strcmpi(subject, mrSESSION.subject) & ~isempty(vANATOMYPATH))
    anatPath = fileparts(vANATOMYPATH);
else
    anatPath = defaultAnatomyPath(subject);
end

% We should check that the directory exists and print out a warning if it
% seems that there is trouble.
pathExists = checkAnatomyPath(anatPath, nargout<2);
return;

%--------------------------------------------
function anatPath = defaultAnatomyPath(subject);
%
% Set up the default anatomy paths, when no information is present, here
%
if (ispref('VISTA','defaultAnatomyPath'))
    anatPath=getpref('VISTA','defaultAnatomyPath');
    disp('Setting default anatomy base path to the one specified in the MATLAB preferences GROUP:VISTA, PREF: defaultAnatomyPath');
    disp(anatPath);
else
    
if ~strcmp(computer,'PCWIN')
    anatPath = ['/biac1/wandell/data']; % 
else
    anatPath = ['X:'];
end % end check on computer type
end % endif preference is set

anatPath = fullfile(anatPath,'anatomy',subject);

return;

%----------------------------------------------
function pathExists = checkAnatomyPath(anatPath,warnFlag)
%
%
pathExists = exist(anatPath,'dir')~=0;
if ~pathExists & warnFlag
    warning(sprintf('Best guess at anatomy directory (%s) non-existent.',anatPath)); 
end
return;

