function [status, errmsg] = ensureDirExists(pth);
%
%  [status, errmsg] = ensureDirExists(pth);
%
% Make sure a directory exists, creating parent
% directories along the way.  Returns status = 1 
% if the path exists or is successfully created,
% status = 0 otherwise. Also returns the error message
% in this case.
%
% ras 06/06.
if ~ischar(pth), help(mfilename); error('Need a path string'); end

status = 0;
errmsg = '';

if exist(pth,'dir')
    % we're done!
    status = 1;
    return
end

% find all the directory strings specified b/w file separators
subdirs = explode(filesep,pth);

if length(subdirs)<2
    error('No file separators found in directory name')
end

% step through each subdir, progressively checking
% child directories within parent dirs
if isunix
    par = [filesep subdirs{1}];
else
    par = subdirs{1};
end

for i = 2:length(subdirs)
    if ~exist(fullfile(par,subdirs{i}),'dir')
        try
            [status, errmsg] = mkdir(par,subdirs{i});
        catch
            disp('ensureDir Exists:')
            fprintf('Creation of intermediate dir failed: ')
            fprintf('%s\n',errmsg)
            return
        end
        fprintf('Created directory %s%s%s\n',par,filesep,subdirs{i});
    end
    
    par = fullfile(par,subdirs{i});
end

status = 1;

return


