function [scans,dt] = er_getScanGroup(view,scan);
% [scans,dt] = er_getScanGroup(view,scan);
%
% Gets the group of scans assigned as a group to the
% current scan; if no group of scans is assigned, prompts
% to assign it. 
%
% See: er_groupScans.
%
% ras 04/07/04: wrote it.
global dataTYPES;

cdt = view.curDataType;

if ieNotDefined('scan')
    scan = getCurScan(view);
end
    
% check if there's a scan group assigned to this scan
if ~isfield(dataTYPES(cdt).scanParams(scan),'scanGroup') | ...
        isempty(dataTYPES(cdt).scanParams(scan).scanGroup)
    er_groupScans(view);
end

% parse the groupScans text into a data type series
% and a set of scans (e.g. 'Original: 1 2 3'):
txt = dataTYPES(cdt).scanParams(scan).scanGroup;
colon = findstr(':',txt);
dtName = txt(1:colon-1);
scans = str2num(txt(colon+2:end));
dt = 1;
while ~isequal(dataTYPES(dt).name,dtName)
    dt = dt + 1;
end

return
