function tc_reorderCondNums(tc,newOrder);
% 
% tc_reorderCondNums(tc,[newOrder]);
%
% Specify a new order for non-null conditions.
% If not specified, will pop up a UI.
%
%
%
% ras 03/05.
if ieNotDefined('tc')
    tc = get(gcf,'UserData');
end


if ieNotDefined('newOrder')
    % put up a dialog
    nums = tc.trials.condNums;
    names = tc.trials.condNames;
    def = {num2str(nums)};
    prompt{1} = 'New Condition # Order [Current Order: ';
    for i = 1:length(names)
        prompt{1} = [prompt{1} num2str(nums(i)) ') ' names{i} ' '];
    end
    prompt{1} = [prompt{1} ']'];
	dlgTitle='Reorder Conditions';
	answer=inputdlg(prompt,dlgTitle,1,def);
    newOrder = str2num(answer{1});
end

% get the indexing needed to produce this
% new order:
% [ignore ind] = sort(newOrder);
newOrder = newOrder + 1; % just account for null

tc.trials.condNums = tc.trials.condNums(newOrder);
tc.trials.condNames = tc.trials.condNames(newOrder);
tc.trials.condColors = tc.trials.condColors(newOrder);

set(gcf,'UserData',tc);

timeCourseUI;

return
