function tc_plotMeanTrials(tc, parent, lineWidth);
% tc_plotMeanTrials(tc, <parent=tc.ui.plot panel>, <lineWidth=2>);
%
% plots mean time courses for each condition, 
% with error bars (SEMs), coded by color.
%
% 02/23/04 ras: broken off as a separate function (previously kept in
% ras_tc).
% 06/04 ras: stores the sorted data in the tc struct as 'meanTcs' for
% further analyses.
% 07/04 ras: big redesign -- the means are already computed using
% er_chopTSeries; this is once again a passive plotting script.
% Also, for what it's worth, I made the line width a bit thinner.
% 08/04 ras: added ability to plot deconvolved rapid event-related data.
if notDefined('tc'),            tc = get(gcf,'UserData');     end
if notDefined('lineWidth'),    lineWidth = 2;                 end

% init axes
if exist('parent', 'var')
    type = get(parent, 'type');
    if isequal(type, 'axes')
        axes(parent);
    elseif ismember(type, {'figure' 'uipanel'})
        axes('Parent', parent);    
    end
end
% cla
hold on

for i = find(tc_selectedConds(tc))
    cond = tc.trials.condNums(i);
    col = tc.trials.condColors{i};
    htmp = errorbar(tc.timeWindow,tc.meanTcs(:,i),tc.sems(:,i));
    set(htmp,'Color', col, 'LineWidth', lineWidth);
end

%grid on

% indicate the peak and baseline periods, if selected
if tc.params.showPkBsl==1
    AX = axis;
	plot(tc.bslPeriod,repmat(AX(3),size(tc.bslPeriod)),...
        'k','LineWidth',3.5);
	plot(tc.peakPeriod,repmat(AX(4),size(tc.peakPeriod)),...
        'r','LineWidth',3.5);	
end

if isfield(tc.params,'axisBounds') & ~isempty(tc.params.axisBounds)
    axis(tc.params.axisBounds);
end

grid on

xlabel('Trial time, secs', 'FontWeight', 'bold', 'FontAngle', 'italic', 'FontSize', 10);
ylabel('% Signal', 'FontWeight', 'bold', 'FontAngle', 'italic', 'FontSize', 10);

return
