function tc_plotDesMtx(tc);
% tc_plotDesMtx(tc): plot the design matrix for 
% the selected time course/parfiles
%
% 07/04 ras.
cla;

% create the design matrix
if tc.params.glmHRF==1
    % use the average selected time course as a predictor
    sel = tc_selectedConds(tc);
    hrf = mean(tc.meanTcs(:,find(sel)),2);
else 
    hrf = 'boynton';
end

tc.desMtx = er_createDesMtx(tc.trialInfo,hrf,length(tc.wholeTc));

imagesc(tc.desMtx);
colorbar vert;
axis tight;
xlabel('Condition/Predictor');
ylabel('Time, fMRI Frames');
title('Includes one constant-term predictor for each scan.');
set(gca,'XTickLabel',tc.condNames);
set(tc.ui.fig,'UserData',tc);

return
