function tc = tc_blurTimeCourse(tc);
%
% tc = tc_blurTimeCourse(tc);
%
% Blur the time course UI time course, same
% as in blur tSeries plot.
%
%
% ras 03/30/05
if ieNotDefined('tc')
    tc = get(gcf,'UserData');
end

tc.wholeTc = blur(tc.wholeTc);

anal = er_chopTSeries2(tc.wholeTc,tc.trials,[],'timeWindow',tc.timeWindow,...
                       'bslPeriod',tc.bslPeriod,'peakPeriod',tc.peakPeriod,...
                       'alpha',tc.params.alpha,'onsetDelta',tc.params.onsetDelta,...
                       'snrConds',tc.params.snrConds,'normBsl',tc.params.normBsl);
                   
% assign over to tc struct (ugly, but there are other fields
% in tc I don't want to erase -- is there a way to eat the whole
% struct in one go?)
fields = fieldnames(anal);
for i = 1:length(fields)
    tc.(fields{i}) = anal.(fields{i});
end

set(gcf,'UserData',tc);

timeCourseUI;

return
