function tc_barMeanAmplitudes(tc, parent);
% tc_barMeanAmplitudes(tc, <parent=tc.ui.plot panel>);
%
% plots a bar graph of mean amplitudes for each condition, 
% with error bars (SEMs), coded by color.
%
% 02/25/04 ras: adapted from tc_plotMeanTrials.
% 07/04 ras: big redesign -- the means are already computed using
% er_chopTSeries; this is once again a passive plotting script.
if nargin<1,    tc = get(gcf,'UserData');     end
if nargin<2,    parent = tc.ui.plot;          end
if parent==gcf | parent==get(gcf, 'CurrentAxes')
    % make a uipanel to fit on the target
    parent = uipanel('Parent', parent, ...
                     'Units', 'normalized', ...
                     'BackgroundColor', get(gcf, 'Color'), ...
                     'Position', [0 0 1 1])
end


axes('Parent', parent); 
cla
hold on

lineWidth = 2;
sel = find(tc_selectedConds(tc));
colors = tc.trials.condColors(sel);
labels = tc.trials.condNames(sel);

for i = sel
    nTrials = sum(~isnan(tc.amps(:,i)));    
    Y(find(sel==i)) = nanmean(tc.amps(:,i));
    E(find(sel==i)) = nanstd(tc.amps(:,i)) ./ sqrt(nTrials-1);
end

mybar(Y, E, labels, labels, colors);

% set line width
htmp = findobj('Type','line','Parent',gca);
set(htmp,'LineWidth',lineWidth);

% add labels
xlabel('Condition', 'FontWeight', 'bold', 'FontAngle', 'italic', 'FontSize', 12);
ylabel('Mean Amplitude, % Signal', 'FontWeight', 'bold', 'FontAngle', 'italic', 'FontSize', 12);

% set axis bounds
AX = axis;
AX(1:2) = [0 length(sel)+1];
if isfield(tc.params,'axisBounds') & ~isempty(tc.params.axisBounds)
    AX(3:4) = tc.params.axisBounds(3:4);
end
axis(AX);

return
