function s = delta_function_from_parfile(parName,tr,ntp);
% s = delta_function_from_parfile(parName,[tr],[ntp]);
% 
% Given the name of a parfile, reads in the info
% and produces a matrix s that has as rows frames
% and as columns conditions (stimulus types). Each
% column is a delta function of onsets.
%
% (If a cell-of-strings is provided for parName,
% will load a list of parfiles, adding each run 
% as the 3rd dimension.)
%
% 11/04 ras.
if ieNotDefined('tr')
    tr = [];
end

if ieNotDefined('ntp')
    ntp = [];
end

s = [];
if iscell(parName)
    % recursively go through each entry
    for p = 1:length(parName)
         tmp = delta_function_from_parfile(parName{p},tr,ntp);
         s(1:size(tmp,1),1:size(tmp,2),p) = tmp;
     end
    return
end

[onsets conds] = readParFile(parName);

% 'shifting' parfile onsets, e.g. to correct for variations in
% when the scan started, may produce negative onsets, which we 
% don't need:
ok = find(onsets>=0);
onsets = onsets(ok);
conds = conds(ok);

if isempty(tr)
    % estimate from parfile
    tr = onsets(2) - onsets(1);
end

whichConds = unique(conds);
nconds = length(whichConds);

if isempty(ntp)
    ntp = ceil(onsets(end) ./ tr);
end

% initialize s
s = zeros(ntp,nconds);

% insert 1s at onset frames
for c = 1:nconds
    trials = onsets(conds==whichConds(c));
    s(trials+1,c) = 1;
end

% truncate if it goes over
s = s(1:ntp,:);

return
