function view = rotateCmap(view, shiftAmount)
%
% view = rotateCmap(view, [shift])
%
% AUTHOR:  Poirson/Boynton/Heeger
% DATE:    01.13.98
% PURPOSE: Rotates colormap with mouse presses.
%          shiftAmount is amount to shift color part of the view's
%          display mode in DEGREES (used to be in numColors, but updated
%          01/06 by ras since this requires detailed knowledge of the
%          view mode settings): 180 degrees means rotate by half the 
%          number of colors, and so on. Positive values of shiftAmount
%          shift the cmap forward, negative values backward. If omitted,
%          a GUI is created for rotating and flipping the cmap.
%   
% HISTORY:  Started with 'mrShiftCmap'
%           03.18.97  gmb  Wrote mrRotateCmap by borrowing from mrvAreaCmap
%           01.13.98  djh  Updated to mrLoadRet-2
%				03.10.99	 wap	Allowed shift to be passed in
%           01.16.06    ras  Rewritten, makes separate GUI w/ slider
mode = sprintf('%sMode', view.ui.displayMode);

nG = view.ui.(mode).numGrays;
nC = view.ui.(mode).numColors;
cmap = view.ui.(mode).cmap(nG+1:end,:);

if notDefined('shiftAmount')
    view.ui.(mode).cmap(nG+1:end,:) = editCmapGUI(view, cmap, nG, nC);
else
    nShift = round(shiftAmount * nC / 360);
    view.ui.(mode).cmap(nG+1:end,:) = circshift(cmap, nShift);
end

refreshScreen(view);

return
% /-------------------------------------------------------------------/ %





% /-------------------------------------------------------------------/ %
function cmap = editCmapGUI(view, cmap, nG, nC);
%  cmap = editCmapGUI(view, cmap, numGrays, numColors);
% GUI to rotate and flip the cmap. May grow this to do other
% nice editing functions, then break off as a standalone function.
% But for now, it's just for rotateCmap.
% ras, 01/06.
hfig = figure('Color', 'w', 'Name', 'Rotate Color Map', 'UserData', cmap);
hax = subplot('Position', [.1 .5 .8 .2]); 

if ~isempty(view.ui.cbarRange), cbarRange = view.ui.cbarRange;
else,                           cbarRange = 1:nC;
end
image(cbarRange, [], 1:nC);
colormap(cmap);
set(gca, 'YTick', []);
title(sprintf('Current colorbar: %s mode', view.ui.displayMode));

%%%%%For polar angle map scans, show the wedge color bar 
params = retinoGetParams(view);
if ~isempty(params) & isequal(params.type, 'polar_angle')
    if isequal(lower(params.direction), 'clockwise')
        direction = 0; dirFlag = 1;
    else                                               
        direction = 1; dirFlag = -1;
    end
    startAngle = params.startAngle + dirFlag*params.width/2;
    if params.visualField==360, params.visualField = 'b';
    else, params.visualField = 'l'; 
    end 
    params.doPlot = 0; params.trueColor = 0;
    image(cmapWedge(cmap, startAngle, direction, params));
    axis image; axis off;
end

%%%%%main slider
cb = ['tmp=get(gcf,''UserData''); delta=round(get(gcbo,''Value'')); ' ...
      'tmp=circshift(tmp,delta); colormap(tmp); ' ...
      'set(gcf,''UserData'',tmp); set(gcbo,''Value'',0); '];
hs = uicontrol('Style', 'slider', 'Min', -nC/2, 'Max', nC/2, 'Value', 0, ...
   'BackgroundColor', 'w', 'ForegroundColor', [.6 .6 .6], ...
   'Units', 'normalized', 'Position', [.1 .2 .6 .08], 'Callback', cb);

%%%%%text label
uicontrol('Style', 'text', 'String', 'Amount of Rotation', ...
    'BackgroundColor', [1 1 1], 'FontSize', 12, ...    
    'Units', 'normalized', 'Position', [.1 .12 .8 .08]);

%%%%%flip button
cb = ['tmp=get(gcf,''UserData''); tmp=flipud(tmp); colormap(tmp); ' ...
      'set(gcf,''UserData'',tmp);'];
hf = uicontrol('Style', 'pushbutton', 'String', 'Flip', 'Callback', cb, ...
    'Units', 'normalized', 'Position', [.75 .2 .2 .05]);

%%%%%reset button
cb = ['tmp=get(gcbo,''UserData''); colormap(tmp); ' ...
      'set(gcf,''UserData'',tmp); '];
hr = uicontrol('Style', 'pushbutton', 'String', 'Reset', 'Callback', cb, ...
    'UserData', cmap, ...
    'Units', 'normalized', 'Position', [.75 .25 .2 .05]);

%%%%%Accept and Cancel buttons
cb = 'cmap=get(gcf,''UserData''); uiresume; ';
uicontrol('Style', 'pushbutton', 'String', 'Accept', 'Callback', cb, ...
    'BackgroundColor', [.1 .5 .1], 'ForegroundColor', [1 1 1], ...
    'Units', 'normalized', 'Position', [.1 .04 .3 .06]);

cb = 'close(gcf); ';
uicontrol('Style', 'pushbutton', 'String', 'Cancel', 'Callback', cb, ...
    'BackgroundColor', [.7 .1 .1], 'ForegroundColor', [1 1 1], ...
    'Units', 'normalized', 'Position', [.5 .04 .3 .06]);

set(gcf, 'CloseRequestFcn', 'uiresume; closereq;');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Wait for user to respond  via GUI % 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
uiwait;

cmap = get(hfig, 'UserData');
delete(hfig);
clear view nG nC

return
