function view = linearizeCmap(view)
%
% AUTHOR: Baseler/Poirson/Huk
% DATE:   3.4.99
% PURPOSE: Correct for the non linear input-output relationship
%	   between colormap entries and colors produced on the
%          the monitor.  This works best for 'hsv' colormaps.
% USAGE:   
% HISTORY:  2.28.97 hab, poirson    Wrote mrLinearCmap
%           3.4.99 huk              Updated to mrLoadRet-2.0
% INPUT:   view (i.e. FLAT, INPLANE, or VOLUME)
% OUTPUT:  view with corrected colormap

gammaLeft = 2;
gammaRight = 1.3;
 
cmap = view.ui.phMode.cmap;

% Check to see if phases are on display
if ~(strcmp(view.ui.displayMode,'ph'))
  disp(' Must be displaying phase data to use this function');
  return
end


%upperCmap = cmap(129:256,:);
%upperCmap = upperCmap .^ (1/gamma);
%cmap(129:256,:)=upperCmap;

cmap(65:96,:) = cmap(65:96,:).^(1/gammaLeft);
cmap(97:128,:) = cmap(97:128,:).^(1/gammaRight);

colormap(cmap);

view.ui.phMode.cmap=cmap;

return





