function view=colorMenu(view)
% 
% view=colorMenu(view)
% 
% ras 05/30/04: added option to set clip modes for each view mode
% Importing and Exporting / AAB, BW

cmmenu = uimenu('Label','Color Map','Separator','on',...
    'ForegroundColor',[0.0 0.0 1.0]);

% Reset Defaults callback:
%  view=resetDisplayModes(view);
%  view=refreshScreen(view);
cb=[view.name,'=resetDisplayModes(',view.name,'); ',...
	view.name,'=refreshScreen(',view.name,');'];
uimenu(cmmenu,'Label','Reset Defaults','Separator','off',...
    'CallBack',cb);
 
rotateSubmenu(view, cmmenu);
coModeSubmenu(view, cmmenu);
ampModeSubmenu(view, cmmenu);
phModeSubmenu(view, cmmenu);
utilitySubmenu(view, cmmenu);
visualFieldSubmenu(view, cmmenu);
mapModeSubmenu(view, cmmenu);

if isequal(view.viewType,'Flat')
    uimenu(cmmenu, 'Label', 'Threshold Curvature', 'Separator', 'on',...
        'CallBack', sprintf('thresholdAnatMap(%s); ',view.name));
end


return;
% /--------------------------------------------------------------------/ %




% /--------------------------------------------------------------------/ %
function view = rotateSubmenu(view, cmmenu);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Rotate cmap submenu
rotateMenu = uimenu(cmmenu,'Label','Rotate/Flip','Separator','on');
 
cb=[view.name,'=flipCmap(',view.name,'); ',...
	view.name,'=refreshScreen(',view.name,',1);'];
uimenu(rotateMenu,'Label','Flip','Separator','off',...
    'CallBack',cb);

% Rotate callback:
%  view=rotateCmap(view,[amount]);
%  view=refreshScreen(view,1);
cb=[view.name,'=rotateCmap(',view.name,', -90); ',...
	view.name,'=refreshScreen(',view.name,',1);'];
uimenu(rotateMenu,'Label','Left 90 degrees','Separator','on',...
    'CallBack',cb);

cb=[view.name,'=rotateCmap(',view.name,', 90); ',...
	view.name,'=refreshScreen(',view.name,',1);'];
uimenu(rotateMenu,'Label','Right 90 degrees','Separator','on',...
    'CallBack',cb);

cb=[view.name,'=rotateCmap(',view.name,', 180); ',...
	view.name,'=refreshScreen(',view.name,',1);'];
uimenu(rotateMenu,'Label','180 degrees','Separator','on',...
    'CallBack',cb);

cb=[view.name,'=rotateCmap(',view.name,'); ',...
	view.name,'=refreshScreen(',view.name,',1);'];
uimenu(rotateMenu,'Label','Rotate/Flip Using GUI','Separator','on',...
    'CallBack',cb);

return
% /--------------------------------------------------------------------/ %




% /--------------------------------------------------------------------/ %
function view = coModeSubmenu(view, cmmenu);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Correlation Mode submenu

comenu = uimenu(cmmenu,'Label','Correlation Mode','Separator','on');

% redGreen callback:
%  view.ui.coMode=setColormap(view.ui.coMode,'redGreenCmap');
%  view=refreshScreen(view,1);
cb=[view.name,'.ui.coMode=setColormap(',...
	view.name,'.ui.coMode,''redGreenCmap''); ',...
	view.name,'=refreshScreen(',view.name,',1);'];
uimenu(comenu,'Label','Red-Green Colormap','Separator','off',...
    'CallBack',cb);

% hot callback:
%  view.ui.coMode=setColormap(view.ui.coMode,'hotCmap');
%  view=refreshScreen(view,1);
cb=[view.name,'.ui.coMode=setColormap(',...
	view.name,'.ui.coMode,''hotCmap''); ',...
	view.name,'=refreshScreen(',view.name,',1);'];
uimenu(comenu,'Label','Hot Colormap','Separator','off',...
    'CallBack',cb);

% cool callback:
%  view.ui.coMode=setColormap(view.ui.coMode,'coolCmap');
%  view=refreshScreen(view,1);
cb=[view.name,'.ui.coMode=setColormap(',...
	view.name,'.ui.coMode,''coolCmap''); ',...
	view.name,'=refreshScreen(',view.name,',1);'];
uimenu(comenu,'Label','Cool Colormap','Separator','off',...
    'CallBack',cb);

% jet callback:
%  view.ui.coMode=setColormap(view.ui.coMode,'jetCmap');
%  view=refreshScreen(view,1);
cb=[view.name,'.ui.coMode=setColormap(',...
	view.name,'.ui.coMode,''jetCmap''); ',...
	view.name,'=refreshScreen(',view.name,',1);'];
uimenu(comenu,'Label','Jet Colormap','Separator','off',...
    'CallBack',cb);

% auto clip mode callback:
%  view = setClipMode(view,'co','auto');
%  view=refreshScreen(view,1);
cbstr = sprintf('%s = setClipMode(%s,''co'',''auto'');',view.name,view.name);
cbstr = sprintf('%s\n%s = refreshScreen(%s,1);',cbstr,view.name,view.name);
uimenu(comenu,'Label','Auto Clip Mode','Separator','on',...
    'CallBack',cbstr);

% manual clip mode callback:
%  view = setClipMode(view,'co');
%  view=refreshScreen(view,1);
cbstr = sprintf('%s = setClipMode(%s,''co'');',view.name,view.name);
cbstr = sprintf('%s\n%s = refreshScreen(%s,1);',cbstr,view.name,view.name);
uimenu(comenu,'Label','Manual Clip Mode','Separator','off',...
    'CallBack',cbstr);

return
% /--------------------------------------------------------------------/ %




% /--------------------------------------------------------------------/ %
function view = ampModeSubmenu(view, cmmenu);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Amplitude Mode submenu

ampmenu = uimenu(cmmenu,'Label','Amplitude Mode','Separator','on');

% redGreen callback:
%  view.ui.ampMode=setColormap(view.ui.ampMode,'redGreenCmap');
%  view=refreshScreen(view,1);
cb=[view.name,'.ui.ampMode=setColormap(',...
	view.name,'.ui.ampMode,''redGreenCmap''); ',...
	view.name,'=refreshScreen(',view.name,',1);'];
uimenu(ampmenu,'Label','Red-Green Colormap','Separator','off',...
    'CallBack',cb);

% hot callback:
%  view.ui.ampMode=setColormap(view.ui.ampMode,'hotCmap');
%  view=refreshScreen(view,1);
cb=[view.name,'.ui.ampMode=setColormap(',...
	view.name,'.ui.ampMode,''hotCmap''); ',...
	view.name,'=refreshScreen(',view.name,',1);'];
uimenu(ampmenu,'Label','Hot Colormap','Separator','off',...
    'CallBack',cb);

% cool callback:
%  view.ui.ampMode=setColormap(view.ui.ampMode,'coolCmap');
%  view=refreshScreen(view,1);
cb=[view.name,'.ui.ampMode=setColormap(',...
	view.name,'.ui.ampMode,''coolCmap''); ',...
	view.name,'=refreshScreen(',view.name,',1);'];
uimenu(ampmenu,'Label','Cool Colormap','Separator','off',...
    'CallBack',cb);

% jet callback:
%  view.ui.ampMode=setColormap(view.ui.ampMode,'jetCmap');
%  view=refreshScreen(view,1);
cb=[view.name,'.ui.ampMode=setColormap(',...
	view.name,'.ui.ampMode,''jetCmap''); ',...
	view.name,'=refreshScreen(',view.name,',1);'];
uimenu(ampmenu,'Label','Jet Colormap','Separator','off',...
    'CallBack',cb);

% auto clip mode callback:
%  view = setClipMode(view,'co','auto');
%  view=refreshScreen(view,1);
cbstr = sprintf('%s = setClipMode(%s,''amp'',''auto'');',view.name,view.name);
cbstr = sprintf('%s\n%s = refreshScreen(%s,1);',cbstr,view.name,view.name);
uimenu(ampmenu,'Label','Auto Clip Mode','Separator','on',...
    'CallBack',cbstr);

% manual clip mode callback:
%  view = setClipMode(view,'co');
%  view=refreshScreen(view,1);
cbstr = sprintf('%s = setClipMode(%s,''amp'');',view.name,view.name);
cbstr = sprintf('%s\n%s = refreshScreen(%s,1);',cbstr,view.name,view.name);
uimenu(ampmenu,'Label','Manual Clip Mode','Separator','off',...
    'CallBack',cbstr);
return
% /--------------------------------------------------------------------/ %



% /--------------------------------------------------------------------/ %
function view = phModeSubmenu(view, cmmenu);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Phase Mode submenu

phmenu = uimenu(cmmenu,'Label','Phase Mode','Separator','on');

cb = [view.name,...
        '=cmapImportModeInformation(',view.name,',''phMode''',',''WedgeMapLeft.mat'');'...
        view.name,'=refreshScreen(',view.name,',1);'];
uimenu(phmenu,'Label','Wedge map (left)','Separator','off',...
    'CallBack',cb);

cb = [view.name,'=cmapImportModeInformation(',view.name,',''phMode''',',''WedgeMapRight.mat'');'...
        view.name,'=refreshScreen(',view.name,',1);'];
uimenu(phmenu,'Label','Wedge map (right)','Separator','off',...
    'CallBack',cb);

cb = [view.name,'=cmapImportModeInformation(',view.name,',''phMode''',',''RingMapE.mat'');'...
        view.name,'=refreshScreen(',view.name,',1);'];
uimenu(phmenu,'Label','Ring map (expanding)','Separator','off',...
    'CallBack',cb);

cb = [view.name,'=cmapImportModeInformation(',view.name,',''phMode''',',''RingMapC.mat'');'...
        view.name,'=refreshScreen(',view.name,',1);'];
uimenu(phmenu,'Label','Ring map (contracting)','Separator','off',...
    'CallBack',cb);

% HSV callback:
%  view.ui.phMode=setColormap(view.ui.phMode,'hsvCmap');
%  view=refreshScreen(view,1);
cb=[view.name,'.ui.phMode=setColormap(',...
	view.name,'.ui.phMode,''hsvCmap''); ',...
	view.name,'=refreshScreen(',view.name,',1);'];
uimenu(phmenu,'Label','HSV Colormap','Separator','on',...
    'CallBack',cb);

% Extended color map callback:
% VOLUME{2}=cmapExtended(VOLUME{2});%
% VOLUME{2}=refreshScreen(VOLUME{2},1);
%
cb= ...
    [view.name,'=cmapExtended(',view.name,'); ',...
	view.name,'=refreshScreen(',view.name,',1);'];
uimenu(phmenu,'Label','Extended Colormap','Separator','off',...
    'CallBack',cb);

% RYGB callback:
%  view.ui.phMode=setColormap(view.ui.phMode,'rygbCmap');
%  view=refreshScreen(view,1);
cb=[view.name,'.ui.phMode=setColormap(',...
	view.name,'.ui.phMode,''rygbCmap''); ',...
	view.name,'=refreshScreen(',view.name,',1);'];
uimenu(phmenu,'Label','RYGB Colormap','Separator','off',...
    'CallBack',cb);

% Jet callback:
%  view.ui.phMode=setColormap(view.ui.phMode,'jetCmap');
%  view=refreshScreen(view,1);
cb=[view.name,'.ui.phMode=setColormap(',...
	view.name,'.ui.phMode,''jetCmap''); ',...
	view.name,'=refreshScreen(',view.name,',1);'];
uimenu(phmenu,'Label','Jet Colormap','Separator','off',...
    'CallBack',cb);

% Jet callback:
%  view.ui.phMode=setColormap(view.ui.phMode,'hotCmap');
%  view=refreshScreen(view,1);
cb=[view.name,'.ui.phMode=setColormap(',...
	view.name,'.ui.phMode,''hotCmap''); ',...
	view.name,'=refreshScreen(',view.name,',1);'];
uimenu(phmenu,'Label','Hot Colormap','Separator','off',...
    'CallBack',cb);


% Linearize callback:
%  view=linearizeCmap(view);
%  view=refreshScreen(view,1);
cb= [view.name,'=linearizeCmap(',view.name,'); ',...
	view.name,'=refreshScreen(',view.name,',1);'];
uimenu(phmenu,'Label','Linearize HSV','Separator','on',...
    'CallBack',cb);

% auto clip mode callback:
%  view = setClipMode(view,'co','auto');
%  view=refreshScreen(view,1);
cbstr = sprintf('%s = setClipMode(%s,''ph'',''auto'');',view.name,view.name);
cbstr = sprintf('%s\n%s = refreshScreen(%s,1);',cbstr,view.name,view.name);
uimenu(phmenu,'Label','Auto Clip Mode','Separator','on',...
    'CallBack',cbstr);

% manual clip mode callback:
%  view = setClipMode(view,'co');
%  view=refreshScreen(view,1);
cbstr = sprintf('%s = setClipMode(%s,''ph'');',view.name,view.name);
cbstr = sprintf('%s\n%s = refreshScreen(%s,1);',cbstr,view.name,view.name);
uimenu(phmenu,'Label','Manual Clip Mode','Separator','off',...
    'CallBack',cbstr);

return
% /--------------------------------------------------------------------/ %




% /--------------------------------------------------------------------/ %
function view = mapModeSubmenu(view, cmmenu);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Parameter map Mode submenu
mapmenu = uimenu(cmmenu,'Label','Parameter Map Mode','Separator','on');

% redGreen callback:
%  view.ui.mapMode=setColormap(view.ui.mapMode,'redGreenCmap');
%  view=refreshScreen(view,1);
cb=[view.name,'.ui.mapMode=setColormap(',...
	view.name,'.ui.mapMode,''redGreenCmap''); ',...
	view.name,'=refreshScreen(',view.name,',1);'];
uimenu(mapmenu,'Label','Red-Green Colormap','Separator','off',...
    'CallBack',cb);

% hot callback:
%  view.ui.mapMode=setColormap(view.ui.mapMode,'hotCmap');
%  view=refreshScreen(view,1);
cb=[view.name,'.ui.mapMode=setColormap(',...
	view.name,'.ui.mapMode,''hotCmap''); ',...
	view.name,'=refreshScreen(',view.name,',1);'];
uimenu(mapmenu,'Label','Hot Colormap','Separator','off',...
    'CallBack',cb);

% cool callback:
%  view.ui.mapMode=setColormap(view.ui.mapMode,'coolCmap');
%  view=refreshScreen(view,1);
cb=[view.name,'.ui.mapMode=setColormap(',...
	view.name,'.ui.mapMode,''coolCmap''); ',...
	view.name,'=refreshScreen(',view.name,',1);'];
uimenu(mapmenu,'Label','Cool Colormap','Separator','off',...
    'CallBack',cb);

% HSV callback:
%  view.ui.mapMode = setColormap(view.ui.mapMode, 'hsvCmap');
%  view = refreshScreen(view,1);
cb=[view.name,'.ui.mapMode=setColormap(',...
	view.name,'.ui.mapMode,''hsvCmap''); ',...
	view.name,'=refreshScreen(',view.name,',1);'];
uimenu(mapmenu, 'Label', 'HSV (Rainbow) Colormap', 'Separator', 'off', ...
       'Callback', cb);

% jet callback:
%  view.ui.mapMode=setColormap(view.ui.mapMode,'jetCmap');
%  view=refreshScreen(view,1);
cb=[view.name,'.ui.mapMode=setColormap(',...
	view.name,'.ui.mapMode,''jetCmap''); ',...
	view.name,'=refreshScreen(',view.name,',1);'];
uimenu(mapmenu, 'Label', 'Jet Colormap', 'Separator', 'off',...
        'CallBack', cb);

% Autumn callback:
%  view = bicolorCmap(view);
%  view=refreshScreen(view,1);
cb=[view.name,'.ui.mapMode=setColormap(',...
	view.name,'.ui.mapMode,''autumnCmap''); ',...
	view.name,'=refreshScreen(',view.name,',1);'];
uimenu(mapmenu,'Label','Autumn Colormap','Separator','off',...
    'CallBack',cb);

% Winter callback:
%  view = bicolorCmap(view);
%  view=refreshScreen(view,1);
cb=[view.name,'.ui.mapMode=setColormap(',...
	view.name,'.ui.mapMode,''winterCmap''); ',...
	view.name,'=refreshScreen(',view.name,',1);'];
uimenu(mapmenu,'Label','Winter Colormap','Separator','off',...
    'CallBack',cb);

% Bicolor callback:
%  view = bicolorCmap(view);
%  view=refreshScreen(view,1);
cb = sprintf('%s = bicolorCmap(%s); ',view.name,view.name);
cb = [cb sprintf('%s = refreshScreen(%s,1);',view.name,view.name)];
uimenu(mapmenu,'Label','Bicolor (Winter+Autumn) Colormap',...
    'Separator','off','CallBack',cb);

% 3-toned Overlap callback:
%  view.ui.mapMode=setColormap(view.ui.mapMode,'jetCmap');
%  view=refreshScreen(view,1);
cb=[view.name,'.ui.mapMode=setColormap(',...
	view.name,'.ui.mapMode,''overlapCmap''); ',...
	view.name,'=refreshScreen(',view.name,',1);'];
uimenu(mapmenu,'Label','Overlap (Red/Green/Yellow) Colormap',...
    'Separator','off','CallBack',cb);


% 3-toned Overlap callback:
%  view.ui.mapMode=setColormap(view.ui.mapMode,'jetCmap');
%  view=refreshScreen(view,1);
cb=[view.name,'.ui.mapMode=setColormap(',...
	view.name,'.ui.mapMode,''overlapCmap''); ',...
	view.name,'=refreshScreen(',view.name,',0);'];
uimenu(mapmenu,'Label','Overlap (Red/Blue/Purple) Colormap',...
    'Separator','off','CallBack',cb);

% auto clip mode callback:
%  view = setClipMode(view,'co','auto');
%  view=refreshScreen(view,1);
cbstr = sprintf('%s = setClipMode(%s,''map'',''auto'');',view.name,view.name);
cbstr = sprintf('%s\n%s = refreshScreen(%s,1);',cbstr,view.name,view.name);
uimenu(mapmenu,'Label','Auto Clip Mode','Separator','on',...
    'CallBack',cbstr);

% manual clip mode callback:
%  view = setClipMode(view,'co');
%  view=refreshScreen(view,1);
cbstr = sprintf('%s = setClipMode(%s,''map'');',view.name,view.name);
cbstr = sprintf('%s\n%s = refreshScreen(%s,1);',cbstr,view.name,view.name);
uimenu(mapmenu,'Label','Manual Clip Mode','Separator','off',...
    'CallBack',cbstr);

return
% /--------------------------------------------------------------------/ %




% /--------------------------------------------------------------------/ %
function view = visualFieldSubmenu(view, cmmenu);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Assign Visual Field Map Parameters submenu:
retinoMapMenu = uimenu(cmmenu, 'Label', 'Set Retinotopy Parameters...', ...
                        'Separator', 'on');

% submenus for assigning visual field map params
% retinoSetParams(view);
cb = sprintf('retinoSetParams(%s); ', view.name);
uimenu(retinoMapMenu, 'Label', 'Current Scan', 'Callback', cb);

% scans = er_selectScans(view); retinoSetParams(view, [], scans); 
cb = [sprintf('scans = er_selectScans(%s); ', view.name) ...
      sprintf('retinoSetParams(%s, [], scans); ', view.name)];
uimenu(retinoMapMenu, 'Label', 'Select Scans', 'Callback', cb);

% retinoSetParams(view, [], 1:numScans(view));
cb = sprintf('retinoSetParams(%s, [], 1:numScans(%s)); ', ...
               view.name, view.name);
uimenu(retinoMapMenu, 'Label', 'All Scans', 'Callback', cb);

% submenus for removing visual field map params
% retinoSetParams(view, [], [], 'none');
cb = sprintf('retinoSetParams(%s, [], [], ''none''); ', view.name);
uimenu(retinoMapMenu, 'Label', 'Un-set Params (Current Scan)', ...
       'Separator', 'on', 'Callback', cb);

% scans = er_selectScans(view); retinoSetParams(view, [], scans, 'none'); 
cb = [sprintf('scans = er_selectScans(%s); ', view.name) ...
      sprintf('retinoSetParams(%s, [], scans, ''none''); ', view.name)];
uimenu(retinoMapMenu, 'Label', 'Un-set Params (Select Scans)', ...
    'Callback', cb);

% retinoSetParams(view, [], 1:numScans(view), 'none');
cb = sprintf('retinoSetParams(%s, [], 1:numScans(%s), ''none''); ', ...
               view.name, view.name);
uimenu(retinoMapMenu, 'Label', 'Un-set Params (All Scans)', ...
    'Callback', cb);

return
% /--------------------------------------------------------------------/ %



% /--------------------------------------------------------------------/ %
function view = utilitySubmenu(view, cmmenu);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% utility mode

utilitymenu = uimenu(cmmenu,'Label','Utilities','Separator','on');

cb = sprintf('loadColormap(%s);', view.name);
uimenu(utilitymenu, 'Label', 'Load Colormap From File', ...
        'Separator', 'off', 'Callback', cb);

cb = [view.name,'=cmapImportModeInformation(',view.name,');'];
uimenu(utilitymenu,'Label','Import Map','Separator','off',...
        'CallBack', cb);

cb = ['cmapExportModeInformation(',view.name,');'];
uimenu(utilitymenu, 'Label', 'Export Map', 'Separator', 'off',...
        'CallBack', cb);

% Rotate the color map so that a particular data phase has the chosen color:
%  view = =cmapSetDataPhase(view);
%  view = refreshScreen(view,1);
cb=[view.name,'=cmapSetDataPhase(',view.name,');',...
	view.name,'=refreshScreen(',view.name,',1);'];
uimenu(utilitymenu,'Label','Set Phase Manually...','Separator','on',...
    'CallBack',cb);

% Rotate the color map so that a particular data phase has the chosen color:
%  view = cmapSetConstantSubmap(view);
%  view = refreshScreen(view,1);
cb=[view.name,'=cmapSetConstantSubmap(',view.name,');',...
	view.name,'=refreshScreen(',view.name,',1);'];
uimenu(utilitymenu,'Label','Set Map Region Gray...','Separator','off',...
    'CallBack',cb);

% cmapRing(FLAT{1},fovealPhase,'b',256,1);
cb= ['cmapRing(',view.name,',[],''b'',256,1);'];
uimenu(utilitymenu,'Label','Ring map legend','Separator','on',...
    'CallBack',cb);

cb= ['cmapWedge(',view.name,');'];
uimenu(utilitymenu,'Label','Wedge map legend','Separator','off',...
    'CallBack',cb);



return
% /--------------------------------------------------------------------/ %
