function v = cmapSetConstantSubmap(v, newColor, mapIndexRange)
%
% v = cmapSetConstantSubmap(v, [newColor], [mapIndexRange])
%
% newColor defaults to [127 127 127]
% user will be prompted to click on the cmap if mapIndexRange is not
% specified.
%
% newColor = [127 127 127];
% FLAT{1} = cmapSetConstantSubmap(FLAT{1}, newColor);
% FLAT{1} = cmapSetConstantSubmap(FLAT{1}, newColor, [0,0.1]);

if(ieNotDefined('newColor'))
    newColor = [127 127 127];
end
if(ieNotDefined('mapIndexRange'))
    h = mrMessage('Click twice on the colorbar to set the range to be blocked out.');
    figure(v.ui.figNum);
    [x,y] = ginput(2);
    mapIndexRange = x;
    cmapClip = viewGet(v,'curModeCmapClip');
    mapIndexRange = mapIndexRange./cmapClip(2);
    close(h);
end

mp = viewGet(v, 'curcmap');

lowerBound = round(mapIndexRange(1)*size(mp,2))+1;
upperBound = round(mapIndexRange(2)*size(mp,2))+1;
lowerBound = max(1,lowerBound);
upperBound = min(size(mp,2), upperBound);

mp(:,lowerBound:upperBound) = repmat(newColor',1,upperBound-lowerBound+1);

v = viewSet(v, 'curcmap', mp);

return;


