function vw = cmapExtended(vw,range)
%
%   vw = cmapExtended(vw,range)
%
% Author: AAB, BW
% Purpose:
%   Compress the current color map to smaller range and add gray at the end.
%
%  vw = FLAT{1};
%
% vw = cmapExtended(vw)
%History: 
% 050321:   Mark Schira changed line 23

numGrays = viewGet(vw,'cmapcurnumgrays');
numColors = viewGet(vw,'cmapcurnumcolors');
mpColors = viewGet(vw,'cmapcurrent');

if ieNotDefined('vw'),  error('Must pass in the view.'); end
if ieNotDefined('range'), range = readRange; end

if (range < 1) | (range > 2),  error('Range must be betweem 1 and 2.'); end

desiredColors = floor(numColors/range); %used to be a round here what I dont understand because 1:range:goal always does "floor" and never ceil 
extraColors = numColors - desiredColors;
newMap = [round(interp1(mpColors',(1:range:numColors)')')];
newMap = [newMap,ones(3,extraColors)*127.5];

vw = viewSet(vw,'cmapphase',newMap);

return;

%----------------------------------------
function range = readRange

prompt={'Enter compression range for the color map (2 = double color map)'};
def={'1.2'};
dlgTitle='Color map compression factor';
lineNo=1;
range=inputdlg(prompt,dlgTitle,lineNo,def);
range = str2num(range{1});

return;
   
