function s=rmSearchFit(view,params,s);
% rmSearchFit - find minimum for retinotopic model per voxel
% stats=rmSearchFit(view,params,stats);
%
% Uses matlab fminsearch (Nelder-Mead simplex (direct search) method).
% Primed by stats structure by rmGridFit.m 
% 
% Output is saved in structure stats (s).
%

% Programming note:

if ieNotDefined('view'),   error('Need view struct'); end;
if ieNotDefined('params'), error('Need params'); end;
if ieNotDefined('s'),      error('Need stats'); end;

%-----------------------------------
%--- make trends to fit with the model (dc, linear and sinewaves)
%-----------------------------------
trends = makeTrends(params);


%-----------------------------------
%--- now loop over slices
%--- but initiate stuff first
%-----------------------------------
switch lower(params.wData(1:3)),
 case {'fig','roi'},
  loopSlices = 1;
 otherwise,
  loopSlices = 1:params.stim(1).nSlices;
end;
numSlices    = length(loopSlices);
imsize = size(params.stim(1).images);

% find lowest p & rss values of all comparisons
pvals = s.model2.p;
rss   = s.model2.rss;
if isfield(params.stim(1),'stimOnOffSeq'),
  % make on/off sequence
  stim = [];
  for ii = 1:length(params.stim),
    stim = [stim; params.stim(ii).stimOnOffSeq];
  end;
  
  % check values of other models
  pvals  = min(pvals,s.model1.p);
  pvals  = min(pvals,s.model3.p);
  rss    = min(rss,s.model1.rss);
  rss    = min(rss,s.model3.rss);
end;

% add fields
fn = fieldnames(s);
for n=1:length(fn),
  zData           = zeros(size(s.(fn{n}).x0));
  s.(fn{n}).niter = zData;
end;

% fminsearch options
searchOptions.TolX    = params.analysis.TolX;
searchOptions.MaxIter = params.analysis.MaxIter;
searchOptions.Display = 'off';
pthresh       = params.analysis.pthresh;
tolFun        = rss.*params.analysis.TolFun;
clear rss;

% go loop over slices
for slice=loopSlices,
  
  %-----------------------------------
  % Place datasets behind each other. This is a rather crude way of
  % stimultaneously fitting both. Due to this we cannot
  % prewhiten (we could zeropadd/let the trends deal with this/not care). 
  %-----------------------------------
  data = rmLoadData(view,params,slice);
  
  %-----------------------------------
  % Now find minimum for each voxel < pthresh
  %-----------------------------------
  wProcess = find(pvals(slice,:)<pthresh);
  fprintf(1,'[%s]: fmins (x,y,sigma) fit:',mfilename);drawnow;tic;
  progress = 0;
  for vi = wProcess,
    % progress monitor (10 dots)
    if round(vi/max(wProcess)*10)>progress,
      fprintf(1,'.');drawnow;
      progress = progress + 1;
    end;
    
    % start point from grid fit
    startParams = [s.model2.x0(slice,vi); ...
                   s.model2.y0(slice,vi); ...
                   s.model2.sigma(slice,vi)];
%    s.model2.rss(slice,vi)
    searchOptions.TolFun = tolFun(slice,vi);

    % actual fminsearch call
    [outParams,rss,exitflag,output] = ...
        fminsearch(@(x) modelSearchFit(x,data(:,vi),trends,params),...
                   startParams,searchOptions);
%    [startParams, outParams],toc
    % store results
    s.model2.x0(slice,vi)    = outParams(1);
    s.model2.y0(slice,vi)    = outParams(2);
    s.model2.sigma(slice,vi) = outParams(3);
    s.model2.niter(slice,vi) = output.iterations;
    s.model2.rss(slice,vi)   = rss;
    % compute t
    pred = makePrediction(outParams,params);
    X    = [pred trends];
    C    = zeros(1,size(X,2)); 
    C(1) = 1;
    s.model2.t(slice,vi)     = rmGLM(data(:,vi),X,C);

    
    % now for model3
    if isfield(params.stim(1),'stimOnOffSeq'),
      startParams = [s.model3.x0(slice,vi); ...
                     s.model3.y0(slice,vi); ...
                     s.model3.sigma(slice,vi)];
      [outParams,rss,exitflag,output] = ...
          fminsearch(@(x) modelSearchFit(x,data(:,vi),[stim trends],params),...
                     startParams,searchOptions)
      s.model3.x0(slice,vi)    = outParams(1);
      s.model3.y0(slice,vi)    = outParams(2);
      s.model3.sigma(slice,vi) = outParams(3);
      s.model3.niter(slice,vi) = output.iterations;
      s.model3.rss(slice,vi)   = rss;
      % compute t
      pred = makePrediction(outParams,params);
      X    = [pred stim trends];
      C    = zeros(1,size(X,2)); 
      C([1 2]) = 1;
      s.model3.t(slice,vi)     = rmGLM(data(:,vi),X,C);
    end;
  end;
  fprintf(1,'Done[%.1fmin].\n',toc/60);drawnow;
end;


%-----------------------------------
%--- compute p values
%-----------------------------------
s.model2.p = rmT2P(s.model2.t,s.model2.df,'p');
s.model2.log10p = rmT2P(s.model2.t,s.model2.df,'log10p');
if isfield(params.stim(1),'stimOnOffSeq'),
  s.model1.p =  rmT2P(s.model1.t,s.model1.df,'p');
  s.model3.p =  rmT2P(s.model3.t,s.model3.df,'p');
  s.model1.log10p = rmT2P(s.model1.t,s.model1.df,'log10p');
  s.model3.log10p = rmT2P(s.model3.t,s.model3.df,'log10p');
end;

% that's it
return;
%-----------------------------------




%-----------------------------------
% $$$ function bnd = findBoundaries(p,gi);
% $$$ % p=start, gi=gridInfo [start step stop]
% $$$ % x0, y0, sigma
% $$$ bnd = p*[1 1] + [gi.x0(2);gi.y0(2);gi.sigma(2)]*[-1.5 1.5];
% $$$ 
% $$$ % boundary checks allow large x0,y0 and sigma at edges
% $$$ if bnd(1,1)<gi.x0(1),   bnd(1,1) = gi.x0(1)*10;  end;
% $$$ if bnd(1,2)>gi.x0(3),   bnd(1,2) = gi.x0(3)*10;  end;
% $$$ if bnd(2,1)<gi.y0(1),   bnd(2,1) = gi.y0(1)*10;  end;
% $$$ if bnd(2,2)>gi.y0(3),   bnd(2,2) = gi.y0(3)*10;  end;
% $$$ if bnd(3,1)<          0,   bnd(3,1) =              0;  end;
% $$$ if bnd(3,2)>gi.sigma(3),   bnd(3,2) = gi.sigma(3)*10;  end;
% $$$ 
% $$$ 
% $$$ return;
%-----------------------------------


%-----------------------------------
function [pred, weight] = makePrediction(p,params);
% make receptive field (normalized by volume)
RF =  rfGaussian2d(params.analysis.X,params.analysis.Y,...
                   p(3),[],[],p(1),p(2));

% compute the amount within the stimulus window to weight the fit
% this penalizes fits of large RFs far away.
weight = sum(RF(:).*params.stim(1).stimwindow(:));
if weight == 0,
  pred = [];
  return;
end;

% same size as the stimulus so we can dot-product
imsize = size(params.stim(1).images);
RF     = repmat(RF,[1 1 imsize(3)]);

% make stim sequence by RF.*stim and convolve with hrf
pred   = zeros(params.stim(1).nFrames,length(params.stim));
for ii = 1:length(params.stim),
  % the next step is the slow part
  stimseq = sum(reshape(RF.*params.stim(ii).images,...
                        [prod(imsize([1 2])) imsize(3)]))';
  tmp     = rfConvolveTC(stimseq,...
                         params.stim(ii).framePeriod,...
                         params.analysis.wHrf);
  pred(:,ii) = tmp(params.stim(ii).prescanDuration+1:end);
end;
pred = pred(:);
return;
%-----------------------------------


%-----------------------------------
function e =modelSearchFit(p,Y,trends,params);

% sigma should be > 0
if p(3)<=0, e = Inf; return; end;

[pred, weight] = makePrediction(p,params);

if weigth==0, e = Inf; return; end;

X = [pred trends];

% fit
b = pinv(X)*Y;

% first fit (RF profile) should be positive
if b(1) < 0,
  e = Inf;
else,
  % RSS weighted by amount within of RF in stimulus window
  e = sum((Y - X*b).^2) ./ weight;
end;

return;
%-----------------------------------

%-----------------------------------
function t=makeTrends(params,x);

sl = params.stim(1).nFrames;
tc = [0:sl-1]'./(sl-1);
trends = [];
trends(:,1) = ones(sl,1);        % dc 

% just dc for now
%nloops = [1:params.analysis.nDCT]/2;
%for n=nloops,
%  trends = [trends cos(tc*2*pi*n)];
%end;

start = 0;
t = trends;
for ii = 2:length(params.stim),
  sz = size(t);
  t(sz(1)+1:sz(1)+sz(1),sz(2)+1:sz(2)+sz(2)) = trends; 
end;
return;
%-----------------------------------
