#! /bin/sh

# Program to run and quit matlab-program rmMain
# It will only work on unix/linux/macosx machines. 
# You should put this program in your path, link it (ln -s) or 
# give the whole path at the command line.
#
# If you send it to 'batch' do not put the command line on the same line as
# the batch command.
#
# 2006/02 SOD: wrote it. 

# input check and help message
if [ $# == 0 ] ; then
    echo "Usage: $0 stimulus-id-number [dataset-path]"
    echo ""
    echo "Program to run and quit matlab and run retinotopic model"
    echo " stimulus id: 1='wedge/ring', "
    echo "              2='wedge/ring on/off'"
    echo " dataset-path defaults to current directory (pwd)"
    echo ""
    echo "Example call:"
    echo "   rmMain.sh 1 /mydatadir > rmMain.log &;"
    echo "This runs rmMain([],[],1) in the background saving the terminal"
    echo "output to rmMain.log"
    echo ""
    exit 1
else
    if [ $# == 1 ] ; then
	stim=$1
	path=`pwd`
    else
	if [ $# == 2 ] ; then
	    stim=$1
	    path=$2
	else
	    echo "Usage: $0 stimulus-id-number [dataset-path]"
	    echo "Error: To many input arguments"
	    exit 1
	fi
    fi
fi

# repeat command
echo $0 $stim $path

# open matlab and run program
matlab -nodisplay <<EOF
    disp(sprintf('cd %s','$path'));
    cd $path;
    disp(sprintf('rmMain([],[],%d);',$stim));
    rmMain([],[],$stim);
    exit;
EOF
# done
