function view = rmMain(view,wData,wStim);
% rmMain - main retinotopy model program
%
% view = rmMain([view],[wData],[wStim]);
%
%   view   : mrVista view structure
%   wData  : load data from vista structure (default) or from 
%            figures (wData = 'figures') or ROI (wData = 'ROI')
%   wStim  : stimulus id number
%
% Does everything.
%

% 2005/2006 SOD: wrote it. 

if ieNotDefined('view'),  view  = []; end;
if ieNotDefined('wData'), wData = 'all'; end;
if ieNotDefined('wStim'), wStim = []; end;

% keep original view
orgview = view;

%-----------------------------------
% define parameters structure used in the rest of the program
%-----------------------------------
[params, view] = rmDefineParameters(view,wStim);
params.wData   = wData;
switch lower(wData),
 case {'roi'},
   if view.selectedROI == 0,
     filename = getROIfilename(view);
     view     = loadROI(view,filename);
   end;
end;    

%-----------------------------------
% make stimuli to dot-product with RF
%-----------------------------------
params = rmMakeStimulus(params);

%-----------------------------------
% Brute force fitting of bank of RFs varying in position
% (x,y) and size (sd) only.
%-----------------------------------
model = rmGridFit(view,params);

% save
%save(sprintf('%s-%s',mfilename,datestr(now,30)));

%-----------------------------------
% Refine fit for each voxel above a certain threshold
%-----------------------------------
%stats = rmSearchFit(view,params,stats);

% save
%save(sprintf('%s-%s',mfilename,datestr(now,30)));

%-----------------------------------
% save and return output (if run interactively)
%-----------------------------------
if nargout,
  output = rmSave(view,model,params,0);
  if ~isempty(orgview),
    view = orgview;
    view = viewSet(view,'rmFile',output);
  end;
else,
  rmSave(view,model,params,1);
end;

