function view = rmLoad(view);
% rmLoad - load results into mrVista interface
% 
%  view = rmLoad(view);
% 
% inputs:
% 
%
% 2006/02 SOD: wrote it.

if ieNotDefined('view'), error('Need view structure'); end;


% get file
try,
  rmFile = viewGet(view,'rmFile');
catch,
  disp(sprintf('[%s]:No file selected',mfilename));
  view = rmSelect(view);
  rmFile = viewGet(view,'rmFile');
end;

% load file (if this is time consuming maybe it should be done
% by rmSelect?) 
load(rmFile,'model');

% get model names
for n=1:length(model),
  modelNames{n} = rmGet(model{n},'desc');
end;


% define params
paramNames = {'x0','y0','eccentricity','polar-angle',...
              'sigma','sigma major','sigma minor','sigma theta',...
              'sigma2','sigma2 major','sigma2 minor','sigma2 theta',...
              'sigma ratio',...
...%              'amplitude comp1','amplitude comp2','amplitude comp3','amplitude comp4',...
              'max(log10p)',...
              'log10p-statistic fullfield','log10p-statistic retinotopy',...
              'log10p-statistic all',...
              'log10p-statistic retinotopy minus fullfield',...
              'log10p-statistic fullfield minus retinotopy',...
              'residual sum of squares'};


% make comparisons names
if length(model) > 1,
  ii = 1;
  for n=1:length(model),
    for m=n+1:length(model),
      compMatrix(ii,:) = [n m];
      compNames{ii} = [modelNames{n} ' <-> ' modelNames{m} ' (glr)'];
      compType{ii} = 'glr';
      ii = ii + 1;
      compMatrix(ii,:) = [n m];
      compNames{ii} = [modelNames{n} ' <-> ' modelNames{m} ' (ftest)'];
      compType{ii} = 'ftest';
      ii = ii + 1;
    end;
  end;
  % combine
  allNames   = [paramNames compNames];
else,
  allNames   = paramNames;
end;


% define field names
fieldNames = {'map','co','amp','ph'};

% get user selection
sel = rmLoadInterface(modelNames,allNames,fieldNames);
if isempty(sel),
  disp(sprintf('[%s]:user cancelled',mfilename));
  return;
end;

if sel.parameter <= length(paramNames),
  % get parameter
  switch allNames{sel.parameter},
   case 'max(log10p)'
    param  = rmGet(model{sel.model},'x').*0;
    ps     = {'log10pf','log10prm','log10pall'};
    for n=1:length(ps),
      param2 = abs(rmGet(model{sel.model},ps{n}));
      if ~isempty(param2),
        param = max(param,param2);
      end;
    end;
   otherwise
    param = rmGet(model{sel.model},allNames{sel.parameter});
  end;
else,
  % compare two models
  ii    = sel.parameter - length(paramNames);
  rss1  = rmGet(model{compMatrix(ii,1)},'rss');
  df1   = rmGet(model{compMatrix(ii,1)},'dfcorr');
  rss2  = rmGet(model{compMatrix(ii,2)},'rss');
  df2   = rmGet(model{compMatrix(ii,2)},'dfcorr');
  n     = rmGet(model{compMatrix(ii,2)},'npoints');
  if length(df1) > 1, df1 = df1(1); end;
  if length(df2) > 1, df2 = df2(1); end;
    
  param = rmEvaluate2Fits(rss1,rss2,df1,df2,n,'log10p',compType{ii});
end;

if isempty(param),
  disp(sprintf('[%s]: %s: parameter not defined.',...
               mfilename,rmGet(model{sel.model},'desc')));
  return;
else,
  % must do some sanity checks here 
  finf = find(param == Inf);
  fmax = max(param(isfinite(param)));
  param(finf) = fmax;
  finf = find(param == -Inf);
  fmin = min(param(isfinite(param)));
  param(finf) = fmin;
  param(find(isnan(param))) = 0;
  
  % if we put this in the 'co' field than we have to make sure the
  % data range from 0>1;
  if strcmp(fieldNames{sel.field},'co'),
    % no values < 0
    if min(param(:))<0,
      param = abs(param);
    end;
    % set max to 50
    if max(param(:))>10,
      param(param>10) = 10;
    end
    % only do this if max > 1
    if max(param(:))>1
      param = param./10;
    end;
  end;
end;

% get old field parameters
oldparam = viewGet(view,fieldNames{sel.field});
if isempty(oldparam),
  oldparam = cell(1,viewGet(view,'numscans'));
end;
oldparam{viewGet(view,'curscan')} = param;
view  = viewSet(view,fieldNames{sel.field},oldparam);
view  = viewSet(view,'mapName',allNames{sel.parameter});

% also set 'ph' if you set 'co' Surface painting expects some
% values here
if strcmp(fieldNames{sel.field},'co'),
  if isempty(viewGet(view,'ph')),
    phparam = cell(1,viewGet(view,'numscans'));
    phparam{viewGet(view,'curscan')} = zeros(size(param));
    view  = viewSet(view,'ph',phparam);
  end;
end;


% refresh
view  = setDisplayMode(view,fieldNames{sel.field});
%view  = refreshScreen(view);


return;

